/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.Person;
import ipsk.db.speech.RecordingFile;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

@Entity
@Table(name="technician")
@PrimaryKeyJoinColumn(name="person_id")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="technician")
@PluralResourceKey(value="technicians")
public class Technician
extends Person {
    private String email;
    private String mobile;
    private Set<RecordingFile> recordingFiles = new HashSet<RecordingFile>(0);

    public Technician() {
    }

    public Technician(int personId) {
        this.personId = personId;
    }

    public Technician(int personId, String email, String mobile, Set<RecordingFile> recordingFiles) {
        this.personId = personId;
        this.email = email;
        this.mobile = mobile;
        this.recordingFiles = recordingFiles;
    }

    @Override
    @Column(name="email", length=100)
    @ResourceKey(value="email")
    public String getEmail() {
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="mobile", length=100)
    @ResourceKey(value="phone.mobile")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="supervises", joinColumns={@JoinColumn(name="technician_id")}, inverseJoinColumns={@JoinColumn(name="recording_id")})
    @ResourceKey(value="recording_files")
    public Set<RecordingFile> getRecordingFiles() {
        return this.recordingFiles;
    }

    public void setRecordingFiles(Set<RecordingFile> recordingFiles) {
        this.recordingFiles = recordingFiles;
    }
}

