/*
 * Date  : 25.03.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class P extends Block{

	public static final String ELEMENT_NAME="p"; 
	private List<TextFormatElement> texts=new ArrayList<TextFormatElement>();


	public List<TextFormatElement> getTexts() {
        return texts;
    }

    public void setTexts(List<TextFormatElement> texts) {
        this.texts = texts;
    }

    /**
	 * 
	 */
	public P() {
		this(null);
	}
	
	public P(Element e) {
	    super();
	    if(e!=null){

	        NodeList textElList=e.getChildNodes();
	        for(int i=0;i<textElList.getLength();i++){

	            Node tn=textElList.item(i);
	            if(tn instanceof Element){
	                Element te=(Element)tn;
	                String teTgNm=te.getTagName();
	                if(Font.ELEMENT_NAME.equals(teTgNm)){
	                    Font f=new Font(te);
	                    texts.add(f);
	                }else if(Text.ELEMENT_NAME.equals(teTgNm)){
	                    Text t=new Text(te);
	                    texts.add(t);
	                }
	            }
	        }
	    }
	}
	
	public Element toElement(Document d){
	    Element e=d.createElement(ELEMENT_NAME);
	    for(TextFormatElement te:texts){
	        e.appendChild(te.toElement(d));
	    }
		return e;
	}
	
	public Object clone() throws CloneNotSupportedException{
        Object c=super.clone();
        P p=(P)c;
        return p;
    }
	
	public String toPlainTextString(){

        StringBuffer sb=new StringBuffer();
       
        for(TextFormatElement ft:texts){
            sb.append(ft.toPlainTextString());
        }
        return sb.toString();
    }
	
	public String toString(){

		StringBuffer sb=new StringBuffer();
		sb.append("<p>");
		for(TextFormatElement ft:texts){
			sb.append(ft.toString());
		}
		sb.append("</p>");
		return sb.toString();
	}


}
