/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.Block;
import ipsk.db.speech.Font;
import ipsk.db.speech.Text;
import ipsk.db.speech.TextFormatElement;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class P
extends Block {
    public static final String ELEMENT_NAME = "p";
    private List<TextFormatElement> texts = new ArrayList<TextFormatElement>();

    public List<TextFormatElement> getTexts() {
        return this.texts;
    }

    public void setTexts(List<TextFormatElement> texts) {
        this.texts = texts;
    }

    public P() {
        this(null);
    }

    public P(Element e) {
        if (e != null) {
            NodeList textElList = e.getChildNodes();
            for (int i = 0; i < textElList.getLength(); ++i) {
                Node tn = textElList.item(i);
                if (!(tn instanceof Element)) continue;
                Element te = (Element)tn;
                String teTgNm = te.getTagName();
                if ("font".equals(teTgNm)) {
                    Font f = new Font(te);
                    this.texts.add(f);
                    continue;
                }
                if (!"text".equals(teTgNm)) continue;
                Text t = new Text(te);
                this.texts.add(t);
            }
        }
    }

    @Override
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        for (TextFormatElement te : this.texts) {
            e.appendChild(te.toElement(d));
        }
        return e;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        P p = (P)c;
        return p;
    }

    @Override
    public String toPlainTextString() {
        StringBuffer sb = new StringBuffer();
        for (TextFormatElement ft : this.texts) {
            sb.append(ft.toPlainTextString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<p>");
        for (TextFormatElement ft : this.texts) {
            sb.append(ft.toString());
        }
        sb.append("</p>");
        return sb.toString();
    }
}

