/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.TypedPropertyDescriptor;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@PreferredDisplayOrder(value="id,propertyClassId,propertyName,required,show,formConfiguration")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="property.configuration")
public class PropertyConfiguration
implements ipsk.beans.form.PropertyConfiguration {
    private int id;
    private FormConfiguration formConfiguration;
    private String propertyClassId;
    private String propertyName;
    private TypedPropertyDescriptor typedPropertyDescriptor;
    private boolean required = true;
    private boolean show = true;

    @ManyToOne
    @ObjectImmutableIfReferenced
    @ResourceKey(value="form.configuration")
    @XmlTransient
    public FormConfiguration getFormConfiguration() {
        return this.formConfiguration;
    }

    public void setFormConfiguration(FormConfiguration formConfiguration) {
        this.formConfiguration = formConfiguration;
    }

    @Id
    @Column(name="id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column
    @ResourceKey(value="class.id")
    public String getPropertyClassId() {
        return this.propertyClassId;
    }

    public void setPropertyClassId(String propertyClassId) {
        this.propertyClassId = propertyClassId;
    }

    @Column
    @ResourceKey(value="name")
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Column
    @ResourceKey(value="property.descriptor")
    public TypedPropertyDescriptor getTypedPropertyDescriptor() {
        return this.typedPropertyDescriptor;
    }

    public void setTypedPropertyDescriptor(TypedPropertyDescriptor typedPropertyDescriptor) {
        this.typedPropertyDescriptor = typedPropertyDescriptor;
    }

    @Column
    @ResourceKey(value="form.property.required")
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Column
    @ResourceKey(value="show")
    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    @Transient
    public Class<?> getBeanClass() {
        String pcid = this.getPropertyClassId();
        String pcClassName = pcid.replaceFirst("java:", "");
        try {
            return Class.forName(pcClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transient
    public PropertyDescriptor getPropertyDescriptor() {
        Class<?> c = this.getBeanClass();
        try {
            BeanInfo bi = Introspector.getBeanInfo(c);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            String pName = this.getPropertyName();
            for (PropertyDescriptor pd : pds) {
                if (!pd.getName().equals(pName)) continue;
                return pd;
            }
        }
        catch (IntrospectionException e) {
            return null;
        }
        return null;
    }
}

