/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.Font;
import ipsk.db.speech.TextFormatElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Text
extends TextFormatElement {
    public static final String ELEMENT_NAME = "text";
    protected static final String ATT_COLOR = "color";
    protected static final String ATT_DECORATION = "decoration";
    public static String NONE = "none";
    public static String UNDERLINE = "underline";
    public static String LINE_THROUGH = "line-through";
    private String decoration = null;
    private String color = null;
    private String text = null;

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDecoration() {
        return this.decoration;
    }

    public void setDecoration(String decoration) {
        this.decoration = decoration;
    }

    public Text() {
    }

    public Text(Element e) {
        Attr attr = e.getAttributeNode(ATT_DECORATION);
        if (attr != null) {
            this.setDecoration(attr.getValue());
        }
        if ((attr = e.getAttributeNode(ATT_COLOR)) != null) {
            this.setColor(attr.getValue());
        }
        NodeList childs = e.getChildNodes();
        String t = null;
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 3) continue;
            if (t == null) {
                t = new String();
            }
            t = t.concat(n.getTextContent());
        }
        this.text = t;
    }

    @Override
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        if (this.decoration != null) {
            e.setAttribute(ATT_DECORATION, this.getDecoration());
        }
        if (this.color != null) {
            e.setAttribute(ATT_COLOR, this.getColor());
        }
        if (this.text != null) {
            e.setTextContent(this.text);
        }
        return e;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Font b = (Font)c;
        return b;
    }

    @Override
    public String toPlainTextString() {
        return this.getText();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<text");
        if (this.color != null) {
            sb.append(" color=\"");
            sb.append(this.color);
            sb.append("\"");
        }
        if (this.decoration != null) {
            sb.append(" decoration=\"");
            sb.append(this.decoration);
            sb.append("\"");
        }
        sb.append(">");
        String t = this.getText();
        if (t != null) {
            sb.append(t);
        }
        sb.append("</text>");
        return sb.toString();
    }
}

