/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.Metadata;
import ipsk.util.ResourceKey;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="property", schema="public")
public class Property
extends BasicPropertyChangeSupport
implements Serializable,
Transferable {
    public static final DataFlavor CLASS_DATA_FLAVOR = new DataFlavor(Property.class, null);
    private int propertyId;
    private Metadata metadata;
    private String key;
    private String value;

    public Property() {
    }

    public Property(int propertyId) {
        this.propertyId = propertyId;
    }

    public Property(int propertyId, Metadata metadata, String key, String value) {
        this.propertyId = propertyId;
        this.metadata = metadata;
        this.key = key;
        this.value = value;
    }

    @Id
    @Column(name="property_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(int propertyId) {
        this.propertyId = propertyId;
    }

    @ManyToOne(cascade={})
    @JoinColumn(name="metadata_id")
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Column(name="key", length=1000)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        String oldKey = this.key;
        this.key = key;
        this.propertyChangeSupport.firePropertyChange("key", oldKey, this.key);
    }

    @Column(name="value", length=100000)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        String oldValue = this.value;
        this.value = value;
        this.propertyChangeSupport.firePropertyChange("value", oldValue, this.value);
    }

    @Override
    @Transient
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    @Override
    @Transient
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CLASS_DATA_FLAVOR};
    }

    @Override
    @Transient
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return CLASS_DATA_FLAVOR.equals(flavor);
    }
}

