/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.adapter.PlainTextMarshalFilterAdapter;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="consent.informed")
@PluralResourceKey(value="consents.informed")
@PreferredDisplayOrder(value="id,speaker,project,date,lastModified,informedConsentInPaperFormSigned,informedConsent,informedBroadConsent")
@XmlType(name="informedConsent", propOrder={"id", "date", "lastModified", "project", "speaker", "informedConsentInPaperFormSigned", "informedConsent", "informedBroadConsent"})
public class InformedConsent {
    private int id;
    private boolean informedConsentInPaperFormSigned = false;
    private String informedConsent = null;
    private String informedBroadConsent = null;
    private Speaker speaker;
    private Date date;
    private Date lastModified;
    private Project project;

    @Id
    @Column(name="id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="person_id")
    @ResourceKey(value="speaker")
    @XmlIDREF
    public Speaker getSpeaker() {
        return this.speaker;
    }

    public void setSpeaker(Speaker speaker) {
        this.speaker = speaker;
    }

    @ManyToOne
    @JoinColumn(name="project")
    @ResourceKey(value="project")
    @XmlIDREF
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Column(name="informed_consent", length=10000)
    @ResourceKey(value="consent.informed")
    @XmlElement(name="text")
    @XmlJavaTypeAdapter(value=PlainTextMarshalFilterAdapter.class)
    public String getInformedConsent() {
        return this.informedConsent;
    }

    public void setInformedConsent(String informedConsent) {
        this.informedConsent = informedConsent;
    }

    @Column(name="informed_consent_broad", length=10000)
    @ResourceKey(value="consent.broad.informed")
    @Input(required=false)
    @XmlElement(name="broadConsentText")
    @XmlJavaTypeAdapter(value=PlainTextMarshalFilterAdapter.class)
    public String getInformedBroadConsent() {
        return this.informedBroadConsent;
    }

    public void setInformedBroadConsent(String informedBroadConsent) {
        this.informedBroadConsent = informedBroadConsent;
    }

    @ResourceKey(value="consent.informed.paperform.signed")
    public boolean isInformedConsentInPaperFormSigned() {
        return this.informedConsentInPaperFormSigned;
    }

    public void setInformedConsentInPaperFormSigned(boolean informedConsentInPaperFormSigned) {
        this.informedConsentInPaperFormSigned = informedConsentInPaperFormSigned;
    }

    @Column(updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="point_in_time")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Column(updatable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="last_modified")
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date updateDate) {
        this.lastModified = updateDate;
    }

    @PrePersist
    public void setCurrentDate() {
        if (this.date == null) {
            this.setDate(new Date());
        }
        this.updateLastModified();
    }

    @PreUpdate
    public void updateLastModified() {
        this.setLastModified(new Date());
    }
}

