/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.dom.DOMRoot;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Account;
import ipsk.db.speech.DialectRegion;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.persistence.Delegate;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Entity
@Table(name="speaker")
@PrimaryKeyJoinColumn(name="person_id")
@DOMRoot
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@NamedQueries(value={@NamedQuery(name="speakers.byOrganisation", query="SELECT spk FROM Organisation orga,Speaker spk WHERE orga = ?1 AND spk MEMBER OF orga.persons"), @NamedQuery(name="speakers.byOrganisation.orderedByRegisteredDesc", query="SELECT spk FROM Organisation orga,Speaker spk WHERE orga = ?1 AND spk MEMBER OF orga.persons ORDER BY spk.registered DESC")})
@DOMAttributes(value={"personId"})
@DOMElements(value={"name", "forename", "code", "address", "sex", "dateOfBirth", "birthPlace", "profession", "dialectRegion", "additionalLanguage", "comments"})
@PreferredDisplayOrder(value="personId,name,forename,code,informedConsents,adress,zipcode,sex,birthYear,dateOfBirth,height,weight,smoker,brace,mouthPiercing,birthPlace,schoolInCity,schoolInCountry,city,country,profession,dialectRegion,motherTongue,motherTongueMother,motherTongueFather,additionalLanguage,comments")
@XmlType(name="speaker", namespace="speaker")
public class Speaker
extends Person
implements ImmutibilityProvider {
    public static final String ELEMENT_NAME = "speaker";
    private String code;
    private String accent;
    private Boolean smoker;
    private Double height;
    private String motherTongue;
    private DialectRegion dialectRegion;
    private Double weight;
    private Boolean brace;
    private Boolean mouthPiercing;
    private String motherTongueMother;
    private String motherTongueFather;
    private String schoolInCity;
    private String schoolInCountry;
    private String additionalLanguage;
    private String musicalInstrument;
    private String type;
    private Account registeredByAccount;
    private Set<InformedConsent> informedConsents = new HashSet<InformedConsent>(0);
    private Set<Session> sessions = new HashSet<Session>(0);
    private String informedBroadConsentDelegate;
    private String informedConsentDelegate;
    private boolean informedConsentInPaperFormSignedDelegate;

    public Speaker() {
    }

    public Speaker(int personId) {
        this();
        this.personId = personId;
    }

    @Override
    @Column(name="code", length=10)
    @ResourceKey(value="code")
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="accent", length=100)
    @ResourceKey(value="accent")
    public String getAccent() {
        return this.accent;
    }

    public void setAccent(String accent) {
        this.accent = accent;
    }

    @Column(name="smoker")
    @ResourceKey(value="smoker")
    public Boolean getSmoker() {
        return this.smoker;
    }

    public void setSmoker(Boolean smoker) {
        this.smoker = smoker;
    }

    @Column(name="mother_tongue", length=100)
    @ResourceKey(value="mother_tongue")
    public String getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(String motherTongue) {
        this.motherTongue = motherTongue;
    }

    @ManyToOne
    @JoinColumn(name="dialect_region")
    @ResourceKey(value="dialect_region")
    public DialectRegion getDialectRegion() {
        return this.dialectRegion;
    }

    public void setDialectRegion(DialectRegion dialectRegion) {
        this.dialectRegion = dialectRegion;
    }

    @Column(name="brace")
    @ResourceKey(value="brace")
    public Boolean getBrace() {
        return this.brace;
    }

    public void setBrace(Boolean brace) {
        this.brace = brace;
    }

    @Column(name="mouth_piercing")
    @ResourceKey(value="mouth_piercing")
    public Boolean getMouthPiercing() {
        return this.mouthPiercing;
    }

    public void setMouthPiercing(Boolean mouthPiercing) {
        this.mouthPiercing = mouthPiercing;
    }

    @Column(name="mother_tongue_mother", length=100)
    @ResourceKey(value="mother_tongue_of_mother")
    public String getMotherTongueMother() {
        return this.motherTongueMother;
    }

    public void setMotherTongueMother(String motherTongueMother) {
        this.motherTongueMother = motherTongueMother;
    }

    @Column(name="mother_tongue_father", length=100)
    @ResourceKey(value="mother_tongue_of_father")
    public String getMotherTongueFather() {
        return this.motherTongueFather;
    }

    public void setMotherTongueFather(String motherTongueFather) {
        this.motherTongueFather = motherTongueFather;
    }

    @Column(name="type", length=8)
    @ResourceKey(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ManyToOne
    @JoinColumn(name="registered_by_account")
    @ResourceKey(value="registered_by_account")
    @XmlTransient
    public Account getRegisteredByAccount() {
        return this.registeredByAccount;
    }

    public void setRegisteredByAccount(Account registeredByAccount) {
        this.registeredByAccount = registeredByAccount;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="speaker")
    @ResourceKey(value="consents.informed")
    @XmlElementWrapper(name="informedConsents")
    @XmlElement(name="informedConsent")
    public Set<InformedConsent> getInformedConsents() {
        return this.informedConsents;
    }

    public void setInformedConsents(Set<InformedConsent> informedConsents) {
        this.informedConsents = informedConsents;
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="speakers")
    @ResourceKey(value="sessions")
    @ObjectImmutableIfReferenced
    @XmlTransient
    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    @Unit(value="m")
    @Column(name="height", precision=8)
    @ResourceKey(value="height")
    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    @Unit(value="kg")
    @Column(name="weight", precision=8)
    @ResourceKey(value="weight")
    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    @Column(name="school_in_city", length=1000)
    @ResourceKey(value="school_in_city")
    public String getSchoolInCity() {
        return this.schoolInCity;
    }

    public void setSchoolInCity(String schoolInCity) {
        this.schoolInCity = schoolInCity;
    }

    @Column(name="school_in_country", length=1000)
    @ResourceKey(value="school_in_country")
    public String getSchoolInCountry() {
        return this.schoolInCountry;
    }

    public void setSchoolInCountry(String schoolInCountry) {
        this.schoolInCountry = schoolInCountry;
    }

    public void setAdditionalLanguage(String additionalLanguage) {
        this.additionalLanguage = additionalLanguage;
    }

    @Column(name="additional_language", length=100)
    @ResourceKey(value="language.additional")
    @Input(required=false)
    public String getAdditionalLanguage() {
        return this.additionalLanguage;
    }

    @Column
    @ResourceKey(value="musical_instrument")
    @Input(required=false)
    public String getMusicalInstrument() {
        return this.musicalInstrument;
    }

    public void setMusicalInstrument(String musicalInstrument) {
        this.musicalInstrument = musicalInstrument;
    }

    public void applyCurrentProject(Project currentProject) {
        InformedConsent ic = this.currentInformedConsent(currentProject);
        if (ic == null) {
            ic = new InformedConsent();
            this.getInformedConsents().add(ic);
        }
        ic.setInformedConsentInPaperFormSigned(this.getInformedConsentInPaperFormSignedDelegate());
        ic.setInformedConsent(this.getInformedConsentDelegate());
        ic.setInformedBroadConsent(this.getInformedBroadConsentDelegate());
        ic.setProject(currentProject);
        ic.setSpeaker(this);
    }

    private InformedConsent currentInformedConsent(Project currentProject) {
        if (currentProject != null) {
            Set<InformedConsent> cnsts = this.getInformedConsents();
            for (InformedConsent cnst : cnsts) {
                Project cnstPrj = cnst.getProject();
                if (!currentProject.equals(cnstPrj)) continue;
                return cnst;
            }
        }
        return null;
    }

    @Transient
    @XmlTransient
    @Delegate
    @ResourceKey(value="consent.broad.informed")
    public String getInformedBroadConsentDelegate() {
        return this.informedBroadConsentDelegate;
    }

    public void setInformedBroadConsentDelegate(String informedBroadConsentDelegate) {
        this.informedBroadConsentDelegate = informedBroadConsentDelegate;
    }

    @Transient
    @XmlTransient
    @Delegate
    @ResourceKey(value="consent.informed")
    public String getInformedConsentDelegate() {
        return this.informedConsentDelegate;
    }

    public void setInformedConsentDelegate(String informedConsentDelegate) {
        this.informedConsentDelegate = informedConsentDelegate;
    }

    @Transient
    @XmlTransient
    @Delegate
    @ResourceKey(value="consent.informed.paperform.signed")
    public boolean getInformedConsentInPaperFormSignedDelegate() {
        return this.informedConsentInPaperFormSignedDelegate;
    }

    @Transient
    public void setInformedConsentInPaperFormSignedDelegate(boolean informedConsentInPaperFormSignedDelegate) {
        this.informedConsentInPaperFormSignedDelegate = informedConsentInPaperFormSignedDelegate;
    }

    public Element toElement(Document d) {
        Element codeElement;
        Element e = d.createElement(ELEMENT_NAME);
        e.setAttribute("personId", Integer.toString(this.personId));
        if (this.code != null) {
            codeElement = d.createElement("code");
            codeElement.setTextContent(this.code);
            e.appendChild(codeElement);
        }
        if (this.code != null) {
            codeElement = d.createElement("code");
            codeElement.setTextContent(this.code);
            e.appendChild(codeElement);
        }
        return e;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isRemovable() {
        if (this.sessions != null && this.sessions.size() > 0) {
            return false;
        }
        return super.isRemovable();
    }

    @Override
    public String toString() {
        Object s = super.toString();
        String name = this.getName();
        String code = this.getCode();
        if ((name == null || "".equals(name)) && code != null && !"".equals(code)) {
            s = (String)s + ", Code: " + code;
        }
        return s;
    }
}

