//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import ipsk.beans.LinkID;
import ipsk.db.speech.Session.Status;
import ipsk.db.speech.Session.Type;
import ipsk.util.ResourceKey;


/**
 * Recording Session DTO
 */



@XmlType(name="sessiondto",namespace="sessiondto")
public class SessionDTO implements java.io.Serializable {
	
	
	

	// Fields    

	private Integer sessionId;
	
	private String uuid;
	
	private String script;
	
	private String project;
	
	private String organisation;
	
	private String code;

	private String environment;

	private String comment;

	private Date date;

	private Type type;

	private Status status=Status.CREATED;
	
	private Date loadedDate;

	private Date startedTrainingDate;

	private Date startedDate;
	
	private Date completedDate;
	

	

	private List<String> speakers = new ArrayList<String>();

	// Constructors

	/** default constructor */
	public SessionDTO() {
		super();
	}

	/** minimal constructor */
	public SessionDTO(int sessionId) {
		this.sessionId = sessionId;
	}
	
	public Session toSession(){
		Session s=new Session();
		s.setSessionId(getSessionId());
		s.setUuid(uuid);
		s.setCode(code);
		s.setEnvironment(environment);
		s.setDate(date);
		s.setType(type);
		s.setStatus(status);
		s.setComment(comment);
		return s;
	}

	

	// Property accessors
	
	@LinkID
	@XmlID
	@XmlJavaTypeAdapter(XMLIntegerAdapter.class)
    public Integer getSessionId() {
		return this.sessionId;
	}

	public void setSessionId(Integer sessionId) {
		this.sessionId = sessionId;
	}

	public String getUuid() {
		return uuid;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	
	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	public String getScript() {
		return this.script;
	}

	public void setScript(String script) {
		this.script = script;
	}

	public String getEnvironment() {
		return this.environment;
	}

	public void setEnvironment(String environment) {
		this.environment = environment;
	}

	public String getComment() {
		return this.comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	
	public String getProject() {
		return this.project;
	}

	public void setProject(String project) {
		this.project = project;
	}


	public Date getDate() {
		return this.date;
	}

	public void setDate(Date date) {
		this.date = date;
	}
	
	public Date getLoadedDate() {
		return loadedDate;
	}

	public void setLoadedDate(Date loadedDate) {
		this.loadedDate = loadedDate;
	}

	public Date getStartedTrainingDate() {
		return startedTrainingDate;
	}

	public void setStartedTrainingDate(Date startedTrainingDate) {
		this.startedTrainingDate = startedTrainingDate;
	}

	public Date getStartedDate() {
		return startedDate;
	}

	public void setStartedDate(Date startedDate) {
		this.startedDate = startedDate;
	}

	public Date getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}
	
	public List<String> getSpeakers() {
		return this.speakers;
	}

	public void setSpeakers(List<String> speakers) {
		this.speakers = speakers;
	}
	
	public Type getType() {
		return type;
	}

	public void setType(Type type) {
		this.type = type;
	}
	
	
	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}
//	
//
//	public String toString(){
//		return "Session: "+sessionId;
//	}
//	
//
	public String getOrganisation() {
		return organisation;
	}

	public void setOrganisation(String organisation) {
		this.organisation = organisation;
	}
	
}
