/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Project;
import ipsk.db.speech.PropertyConfiguration;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="form.configuration")
@PluralResourceKey(value="form.configurations")
@PreferredDisplayOrder(value="id,displayName,description,defaultRequired,*")
public class FormConfiguration
implements ipsk.beans.form.FormConfiguration {
    private int id;
    private Set<Project> speakerFormProjects = new HashSet<Project>();
    private String displayName;
    private String description;
    private String propertyClassId;
    private boolean defaultRequired = true;
    private List<PropertyConfiguration> inputPropertyConfigurations = new ArrayList<PropertyConfiguration>();

    @OneToMany(mappedBy="speakerFormConfiguration")
    @ResourceKey(value="projects")
    @ObjectImmutableIfReferenced
    @XmlTransient
    public Set<Project> getSpeakerFormProjects() {
        return this.speakerFormProjects;
    }

    public void setSpeakerFormProjects(Set<Project> speakerFormProjects) {
        this.speakerFormProjects = speakerFormProjects;
    }

    @Id
    @Column(name="id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ResourceKey(value="name.display")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Column(length=1000)
    @TextAreaView
    @ResourceKey(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ResourceKey(value="class.id")
    public String getPropertyClassId() {
        return this.propertyClassId;
    }

    public void setPropertyClassId(String propertyClassId) {
        this.propertyClassId = propertyClassId;
    }

    @OneToMany(mappedBy="formConfiguration", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderColumn(name="position")
    @ResourceKey(value="property.configurations")
    public List<PropertyConfiguration> getInputPropertyConfigurations() {
        return this.inputPropertyConfigurations;
    }

    public void setInputPropertyConfigurations(List<PropertyConfiguration> inputpropertyConfiguartions) {
        this.inputPropertyConfigurations = inputpropertyConfiguartions;
    }

    @ResourceKey(value="defaults.required")
    public boolean isDefaultRequired() {
        return this.defaultRequired;
    }

    public void setDefaultRequired(boolean defaultRequired) {
        this.defaultRequired = defaultRequired;
    }

    @Transient
    public Class<?> getBeanClass() {
        String pcid = this.getPropertyClassId();
        String pcClassName = pcid.replaceFirst("java:", "");
        try {
            return Class.forName(pcClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transient
    public List<ipsk.beans.form.PropertyConfiguration> getPropertyConfigurations() {
        List<PropertyConfiguration> persInputPropCfgs = this.getInputPropertyConfigurations();
        ArrayList<ipsk.beans.form.PropertyConfiguration> list = new ArrayList<ipsk.beans.form.PropertyConfiguration>();
        list.addAll(persInputPropCfgs);
        return list;
    }

    @Transient
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.displayName != null) {
            sb.append(this.displayName);
            sb.append(" (ID: ");
            sb.append(this.id);
            sb.append(")");
        } else {
            sb.append("ID: ");
            sb.append(this.id);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        FormConfiguration fc = new FormConfiguration();
        fc.setPropertyClassId("java:");
    }
}

