/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.dom.DOMRoot;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="dialect_region", schema="public")
@DOMRoot
@DOMElements(value={"name", "iso_3166_2_code", "country", "state"})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="dialectRegionId,name,iso_3166_2_code,country,state,alternative,projects,speakers")
public class DialectRegion
implements Serializable {
    private static final long serialVersionUID = -4971565995450009131L;
    private int dialectRegionId;
    private String state;
    private Integer position;
    private String country;
    private String iso_3166_2_code;
    private String name;
    private boolean alternative = false;
    private Set<Project> projects = new HashSet<Project>(0);
    private Set<Speaker> speakers = new HashSet<Speaker>(0);

    public DialectRegion() {
    }

    public DialectRegion(int dialectRegionId) {
        this.dialectRegionId = dialectRegionId;
    }

    public DialectRegion(int dialectRegionId, String state, String country, String name, Integer position, Set<Project> projects, Set<Speaker> speakers) {
        this.dialectRegionId = dialectRegionId;
        this.state = state;
        this.country = country;
        this.name = name;
        this.position = position;
        this.projects = projects;
        this.speakers = speakers;
    }

    @Id
    @Column(name="dialect_region_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @LinkID
    @ResourceKey(value="id")
    public int getDialectRegionId() {
        return this.dialectRegionId;
    }

    public void setDialectRegionId(int dialectRegionId) {
        this.dialectRegionId = dialectRegionId;
    }

    @Column(name="state", length=1000)
    @ResourceKey(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="country", length=1000)
    @ResourceKey(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Column(name="name", length=1000)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="position")
    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    @ManyToMany(mappedBy="dialectRegions", fetch=FetchType.LAZY)
    @ResourceKey(value="projects")
    @XmlTransient
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    @ResourceKey(value="speakers")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dialectRegion")
    @XmlTransient
    public Set<Speaker> getSpeakers() {
        return this.speakers;
    }

    public void setSpeakers(Set<Speaker> speakers) {
        this.speakers = speakers;
    }

    @Column(length=6)
    @ResourceKey(value="iso-3166-2_code")
    public String getIso_3166_2_code() {
        return this.iso_3166_2_code;
    }

    public void setIso_3166_2_code(String iso_3166_2_code) {
        this.iso_3166_2_code = iso_3166_2_code;
    }

    @Column
    @ResourceKey(value="alternative")
    public boolean isAlternative() {
        return this.alternative;
    }

    public void setAlternative(boolean alternative) {
        this.alternative = alternative;
    }

    public String toString() {
        return this.name;
    }
}

