/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script.prompt;

import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.script.prompt.Presenter;
import ipsk.persistence.IntegerSequenceGenerator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="recording")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public class Recprompt
extends PromptItem
implements Serializable,
PropertyChangeListener {
    protected static final String ELEMENT_NAME = "recprompt";
    private String[] comments = new String[0];

    public Recprompt() {
    }

    public Recprompt(IntegerSequenceGenerator seqGen, Element e) {
        this();
        if (seqGen != null) {
            this.setRecpromptId(seqGen.getAndIncrement());
        }
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() != 8) continue;
            commentsArrList.add(n.getNodeValue());
        }
        this.comments = commentsArrList.toArray(new String[0]);
        NodeList prE = e.getElementsByTagName("presenter");
        int prELen = prE.getLength();
        if (prELen >= 1) {
            Presenter presenter = new Presenter((Element)prE.item(0));
            this.setPresenter(presenter);
        }
    }

    @Override
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        for (String comm : this.comments) {
            e.appendChild(d.createComment(comm));
        }
        Presenter p = this.getPresenter();
        if (p != null) {
            e.appendChild(p.toElement(d));
        }
        List<Mediaitem> mis = this.getMediaitems();
        for (Mediaitem mi : mis) {
            e.appendChild(mi.toElement(d));
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "recprompt." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }
}

