package ipsk.db.speech.account;

import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;


@Entity
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder("id,uuid,login,email,requestDate,validUntil")
public class AccountRequest {

	private int id;
	
	@Id
	@Column(unique = true, nullable = false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
	@LinkID
	@XmlID
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	private UUID uuid;
	
	@Column(unique = true,nullable = false)
	@ResourceKey("uuid")
	public UUID getUuid() {
		return uuid;
	}

	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}

	@ResourceKey("login")
	public String getLogin() {
		return login;
	}

	public void setLogin(String login) {
		this.login = login;
	}

	@ResourceKey("email")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@ResourceKey("date")
	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

	@ResourceKey("valid.until")
	public Date getValidUntil() {
		return validUntil;
	}

	public void setValidUntil(Date validUntil) {
		this.validUntil = validUntil;
	}

	private String login;
	private String email;
	
	private Date requestDate;
	private Date validUntil;
	
	public AccountRequest() {
		
	}

	public AccountRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil) {
		super();
		this.uuid=uuid;
		this.login=login;
		this.email=email;
		this.requestDate=requestDate;
		this.validUntil=validUntil;
	}
	
	public boolean equals(Object o){
		if(o != null && o instanceof AccountRequest){
			AccountRequest prr=(AccountRequest)o;
			return(prr.getLogin().equals(login) && 
			   prr.getUuid().equals(uuid));
		}
		return false;
	}
	
	@Transient
	public boolean isValid(){
		Date now=new Date();
		return now.before(validUntil);
	}
	

}
