//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech.script.prompt;



import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlSeeAlso;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ipsk.db.speech.script.PromptItem;
import ipsk.persistence.IntegerSequenceGenerator;

/**
 * Represents a recprompt element of the recording script.
 * Recprompt generated by hbm2java
 */
@Entity
@Table(name = "recording")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
//@XmlSeeAlso({PromptItem.class})
public class Recprompt extends PromptItem implements Serializable,PropertyChangeListener{

	protected static final String ELEMENT_NAME = "recprompt";
	private String[] comments=new String[0];

	// Fields   

	// Constructors

	/** default constructor */
	public Recprompt() {
		super();
	}
	public Recprompt(IntegerSequenceGenerator seqGen, Element e){
		this();
		if(seqGen!=null){
			setRecpromptId(seqGen.getAndIncrement());
		}
		NodeList childs=e.getChildNodes();
		ArrayList<String>commentsArrList=new ArrayList<String>();
		for(int ci=0;ci<childs.getLength();ci++){
			Node n=childs.item(ci);
			if(n.getNodeType()==Node.COMMENT_NODE){
				commentsArrList.add(n.getNodeValue());
			}
		}
		comments=commentsArrList.toArray(new String[0]);
		NodeList prE=e.getElementsByTagName(Presenter.ELEMENT_NAME);
		int prELen=prE.getLength();
		if(prELen>=1){
			Presenter presenter=new Presenter((Element)prE.item(0));
			setPresenter(presenter);
		}
	}

	public Element toElement(Document d) {
		Element e = d.createElement(ELEMENT_NAME);
		
		for(String comm:comments){
			e.appendChild(d.createComment(comm));
		}
//		 TODO wrong mapping script <-> DB !!
//		Recinstructions recInstr=getRecinstructions();
//		if(recInstr!=null){
//		e.appendChild(recInstr.toElement(d));
//		}
		Presenter p=getPresenter();
		if(p!=null){
		    e.appendChild(p.toElement(d));
		}
		List<Mediaitem> mis=getMediaitems();
		for(Mediaitem mi:mis){
		    e.appendChild(mi.toElement(d));
		}
		
//		 TODO wrong mapping script <-> DB !!
//		Reccomment recComment=getReccomment();
//		if(recComment!=null){
//		e.appendChild(recComment.toElement(d));
//		}
		return e;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		String propName=evt.getPropertyName();
		String hPropName=ELEMENT_NAME+"."+propName;
		propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
	}

}
