package ipsk.db.speech.script.prompt.doc;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlType;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Entity
@Table(name = "fmt_prompt_textformat_element")
@DiscriminatorValue("linebreak")
@XmlType(namespace="promptdoc",propOrder = {})
public class Linebreak extends TextFormatElement {

	public static final String ELEMENT_NAME="br"; 
	
	public Linebreak() {
		super();
	}
	public Linebreak(Element e) {
	    super();
	    if(e!=null){
	    	// intentionally empty
	    }
	}

	@Override
	public Element toElement(Document d) {
		Element e=d.createElement(ELEMENT_NAME);
		return e;
	}

	@Override
	public String toPlainTextString() {
		return "\n";
	}
	
	public String toString() {
		return "<"+ELEMENT_NAME+"/>";
	}

}
