/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.RecordingFile;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="recording_track")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="recording_track")
@PluralResourceKey(value="recording_tracks")
@PreferredDisplayOrder(value="recordingTrackId,recordingFile,channelIndex,*")
public class RecordingTrack
implements Serializable {
    private int recordingTrackId;
    private int channelIndex;
    private RecordingFile recordingFile;
    private Double maxLevel = null;
    private Double estimatedSNR = null;

    @Id
    @Column(name="recording_track_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getRecordingTrackId() {
        return this.recordingTrackId;
    }

    public void setRecordingTrackId(int recordingTrackId) {
        this.recordingTrackId = recordingTrackId;
    }

    @Column(name="channel_index")
    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    @Column(name="max_level", nullable=true)
    @ResourceKey(value="audio.level.max")
    public Double getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(Double maxRecordingLevel) {
        this.maxLevel = maxRecordingLevel;
    }

    @XmlTransient
    @Column(name="snr_estimated", nullable=true)
    public Double getEstimatedSNR() {
        return this.estimatedSNR;
    }

    public void setEstimatedSNR(Double estimatedSNR) {
        this.estimatedSNR = estimatedSNR;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="recording_file_id")
    @ResourceKey(value="recording_file")
    @XmlTransient
    public RecordingFile getRecordingFile() {
        return this.recordingFile;
    }

    public void setRecordingFile(RecordingFile recordingFile) {
        this.recordingFile = recordingFile;
    }
}

