/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.account;

import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;

@Entity
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="id,uuid,login,email,requestDate,validUntil")
public class AccountRequest {
    private int id;
    private UUID uuid;
    private String login;
    private String email;
    private Date requestDate;
    private Date validUntil;

    @Id
    @Column(unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @LinkID
    @XmlID
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Column(unique=true, nullable=false)
    @ResourceKey(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @ResourceKey(value="login")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @ResourceKey(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ResourceKey(value="date")
    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    @ResourceKey(value="valid.until")
    public Date getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.validUntil = validUntil;
    }

    public AccountRequest() {
    }

    public AccountRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil) {
        this.uuid = uuid;
        this.login = login;
        this.email = email;
        this.requestDate = requestDate;
        this.validUntil = validUntil;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AccountRequest) {
            AccountRequest prr = (AccountRequest)o;
            return prr.getLogin().equals(this.login) && prr.getUuid().equals(this.uuid);
        }
        return false;
    }

    @Transient
    public boolean isValid() {
        Date now = new Date();
        return now.before(this.validUntil);
    }
}

