/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Account;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="message")
@NamedQuery(name="message.forLogin", query="SELECT m FROM Message m WHERE m.accountByToLogin.login = ?1 ORDER BY m.dateSent DESC")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="message")
@PreferredDisplayOrder(value="messageId,accountByFromLogin,subject,dateSent,status")
public class Message
implements Serializable {
    public static final String SENT = "Sent";
    public static final String READ = "Read";
    public static final String ANSWERED = "Answered";
    public static final String DELETED = "Deleted";
    private int messageId;
    private Message replyOf;
    private Account accountByToLogin;
    private Account accountByFromLogin;
    private String subject;
    private String contents;
    private Date dateSent;
    private String status;
    private String comment;
    private Date dateRead;
    private Date dateConfirmed;

    public Message() {
    }

    public Message(int messageId) {
        this.messageId = messageId;
    }

    public Message(int messageId, Message replyOf, Account accountByToLogin, Account accountByFromLogin, String subject, String contents, Date dateSent, String status, String comment, Date dateRead, Date dateConfirmed) {
        this.messageId = messageId;
        this.replyOf = replyOf;
        this.accountByToLogin = accountByToLogin;
        this.accountByFromLogin = accountByFromLogin;
        this.subject = subject;
        this.contents = contents;
        this.dateSent = dateSent;
        this.status = status;
        this.comment = comment;
        this.dateRead = dateRead;
        this.dateConfirmed = dateConfirmed;
    }

    @Id
    @Column(name="message_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    @ManyToOne
    @JoinColumn(name="reply_of")
    @ResourceKey(value="msg.reply_of")
    public Message getReplyOf() {
        return this.replyOf;
    }

    public void setReplyOf(Message message) {
        this.replyOf = message;
    }

    @ManyToOne
    @JoinColumn(name="to_login")
    @ResourceKey(value="to")
    public Account getAccountByToLogin() {
        return this.accountByToLogin;
    }

    public void setAccountByToLogin(Account accountByToLogin) {
        this.accountByToLogin = accountByToLogin;
    }

    @ManyToOne
    @JoinColumn(name="from_login")
    @ResourceKey(value="from")
    public Account getAccountByFromLogin() {
        return this.accountByFromLogin;
    }

    public void setAccountByFromLogin(Account accountByFromLogin) {
        this.accountByFromLogin = accountByFromLogin;
    }

    @Column(name="subject", length=1000)
    @ResourceKey(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Column(name="contents", length=10000)
    @TextAreaView
    @ResourceKey(value="message")
    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    @Column(name="date_sent")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="date.sent")
    public Date getDateSent() {
        return this.dateSent;
    }

    public void setDateSent(Date dateSent) {
        this.dateSent = dateSent;
    }

    @Column(name="status", length=100)
    @ResourceKey(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="comment")
    @ResourceKey(value="comments")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="date_read")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="date.read")
    public Date getDateRead() {
        return this.dateRead;
    }

    public void setDateRead(Date dateRead) {
        this.dateRead = dateRead;
    }

    @PrePersist
    public void send() {
        this.setDateSent(new Date());
        this.setStatus(SENT);
    }

    @Column(name="date_confirmed")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="date.confirmed")
    public Date getDateConfirmed() {
        return this.dateConfirmed;
    }

    public void setDateConfirmed(Date dateConfirmed) {
        this.dateConfirmed = dateConfirmed;
    }

    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        retBuffer.append("ID: ");
        retBuffer.append(this.messageId);
        if (this.subject != null && !this.subject.equals("")) {
            retBuffer.append(", ");
            retBuffer.append(this.subject);
        }
        return retBuffer.toString();
    }
}

