/*
 * Date  : 18.05.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;

import java.io.Serializable;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@Entity
@Table(name = "fmt_prompt_textformat_element")
@Cacheable
//@ResourceBundleName("ipsk.db.speech.PropertyNames")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlSeeAlso({Font.class,Text.class,Linebreak.class})
public abstract class TextFormatElement implements Serializable{

	private int id;
	@Id
	@Column(name = "id", unique = true, nullable = false)
	@GeneratedValue(generator="id_gen")
	@ResourceKey("id")
	@XmlTransient
	public int getId() {
		return id;
	}
	public void setId(int textFormatElementId) {
		this.id = textFormatElementId;
	}
	
	protected Block block;
	@ManyToOne
	@XmlTransient
	public Block getBlock() {
		return block;
	}
	public void setBlock(Block block) {
		this.block = block;
	}

    public abstract Element toElement(Document d);
    public abstract String toPlainTextString();

}
