package ipsk.db.speech;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.validation.Input;
import ipsk.db.speech.adapter.PlainTextMarshalFilterAdapter;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@Entity
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("consent.informed")
@PluralResourceKey("consents.informed")
@PreferredDisplayOrder("id,speaker,project,date,lastModified,informedConsentInPaperFormSigned,informedConsent,informedBroadConsent")
@XmlType(name = "informedConsent", propOrder = {"id","date","lastModified","project","speaker","informedConsentInPaperFormSigned","informedConsent","informedBroadConsent"})
public class InformedConsent {

	private int id;
	
	private boolean informedConsentInPaperFormSigned=false;

	private String informedConsent=null;
	
	private String informedBroadConsent=null;

	private Speaker speaker;
	
	private Date date;
	
	private Date lastModified;

	@Id
	@Column(name = "id", unique = true, nullable = false)
	@GeneratedValue(generator="id_gen")
	@ResourceKey("id")
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}

	@ManyToOne
	@JoinColumn(name = "person_id")
	@ResourceKey("speaker")
	@XmlIDREF
	public Speaker getSpeaker() {
		return speaker;
	}

	public void setSpeaker(Speaker speaker) {
		this.speaker = speaker;
	}

	private Project project;
	
	@ManyToOne
	@JoinColumn(name = "project")
	@ResourceKey("project")
	@XmlIDREF
	public Project getProject() {
		return this.project;
	}

	public void setProject(Project project) {
		this.project = project;
	}

	public InformedConsent() {
		super();
	}
	
	@Column(name = "informed_consent",length=10000)
	@ResourceKey("consent.informed")
	@XmlElement(name="text")
	@XmlJavaTypeAdapter(PlainTextMarshalFilterAdapter.class)
	public String getInformedConsent() {
		return informedConsent;
	}

	public void setInformedConsent(String informedConsent) {
		this.informedConsent = informedConsent;
	}

	@Column(name = "informed_consent_broad",length=10000)
	@ResourceKey("consent.broad.informed")
	@Input(required=false)
	@XmlElement(name="broadConsentText")
	@XmlJavaTypeAdapter(PlainTextMarshalFilterAdapter.class)
	public String getInformedBroadConsent() {
		return informedBroadConsent;
	}

	public void setInformedBroadConsent(String informedBroadConsent) {
		this.informedBroadConsent = informedBroadConsent;
	}

	
	@ResourceKey("consent.informed.paperform.signed")
	public boolean isInformedConsentInPaperFormSigned() {
		return informedConsentInPaperFormSigned;
	}

	public void setInformedConsentInPaperFormSigned(boolean informedConsentInPaperFormSigned) {
		this.informedConsentInPaperFormSigned = informedConsentInPaperFormSigned;
	}
	
	@Column(updatable=false)
	@Temporal(TemporalType.TIMESTAMP)
	@ResourceKey("point_in_time")
	public Date getDate() {
		return this.date;
	}

	public void setDate(Date date) {
		this.date = date;
	}
	
	@Column(updatable=true)
	@Temporal(TemporalType.TIMESTAMP)
	@ResourceKey("last_modified")
	public Date getLastModified() {
		return this.lastModified;
	}

	public void setLastModified(Date updateDate) {
		this.lastModified = updateDate;
	}

	@PrePersist
	public void setCurrentDate(){
		if(date==null){
			setDate(new Date());
		}
		updateLastModified();
	}
	
	@PreUpdate
	public void updateLastModified(){
		setLastModified(new Date());
	}
	
	
	

}
