/*
 * Date  : 25.03.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@Entity
@Table(name = "fmt_prompt_textformat_element")
@DiscriminatorValue("text")
//@ResourceBundleName("ipsk.db.speech.PropertyNames")
//@ResourceKey("text.element")
//@PluralResourceKey("text.elements")
@XmlType(namespace="promptdoc",propOrder = {"color","decoration","text"})
public class Text  extends TextFormatElement{

	public static final String ELEMENT_NAME="text";
	
	protected static final String ATT_COLOR = "color";
	protected static final String ATT_DECORATION = "decoration";
    public static String NONE="none";
    public static String UNDERLINE="underline";
    public static String LINE_THROUGH="line-through";
    
    private String decoration=null;
    
    private String color=null; 

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    private String text=null;

    @Column(length = 100000)
    //@XmlElement(name="text")
	public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDecoration() {
        return decoration;
    }

    public void setDecoration(String decoration) {
        this.decoration = decoration;
    }

	public Text() {
		super();
	}

	public Text(Element e) {
		super();
		Attr attr = e.getAttributeNode(ATT_DECORATION);
		if (attr != null) {
			setDecoration(attr.getValue());
		}
		attr = e.getAttributeNode(ATT_COLOR);
		if (attr != null) {
			setColor(attr.getValue());
		}

		NodeList childs = e.getChildNodes();
		String t = null;
		for (int ci = 0; ci < childs.getLength(); ci++) {
			Node n = childs.item(ci);
			if (n.getNodeType() == Node.TEXT_NODE) {
				if (t == null) {
					// there should be only one text node, but we concatenate anyway
					t = new String();
				}
				t = t.concat(n.getTextContent());
			}
		}
		// single text node
		text = t;
	}
	
	public Element toElement(Document d){
	    Element e=d.createElement(ELEMENT_NAME);
	    if(decoration!=null){
	        e.setAttribute(ATT_DECORATION, getDecoration());
	    }
	    if(color!=null){
            e.setAttribute(ATT_COLOR, getColor());
        }
	    if(text!=null){
	        e.setTextContent(text);
	    }

	    return e;
	}

    
    public Object clone() throws CloneNotSupportedException{
        Object c=super.clone();
        Font b=(Font)c;
        return b;
    }
    
	public String toPlainTextString() {
		return getText();
	}
    
    public String toString(){

        StringBuffer sb=new StringBuffer();
        sb.append("<"+ELEMENT_NAME);
        if(color!=null){
            sb.append(" "+ATT_COLOR+"=\"");
            sb.append(color);
            sb.append("\"");
        }
        if(decoration!=null){
            sb.append(" "+ATT_DECORATION+"=\"");
            sb.append(decoration);
            sb.append("\"");
        }
        
        sb.append(">");
        String t=getText();
        if(t!=null){
            sb.append(t);
        }
        sb.append("</"+ELEMENT_NAME+">");
        return sb.toString();
    }
}
