/*
 * Date  : 10.05.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@PreferredDisplayOrder("displayName")
public enum SpeechRecorderClient {
    SINGLE_SESSION_WEBSTART("single_session_webstart","Classic SpeechRecorder single session Java WebStart"),
    HTML5_ANGULAR("HTML5_Angular","HTML5 Angular browser web application");
    //HTML5("HTML5","HTML5 browser web application");

	String displayName;
	
	public String getDisplayName() {
		return displayName;
	}
	
	// required for JSP EL 
	public String getName() {
		return name();
	}
	
	SpeechRecorderClient(String value,String displayName) {
    	this.value = value;
    	this.displayName=displayName;
    }
    private final String value;

    public String value() {
    	return value; 
    }
    public String toString() {
    	return value; 
    }
    
   
    public String getValue(){
    	return value;
    }
    
  
    
}