//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech.script;


import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.util.ResourceKey;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * Represents a key,value pair in the metadata element of the recording script.
 * Property generated by hbm2java
 */
@Entity
//@Cacheable
@Table(name = "property", schema = "public")
public class Property extends BasicPropertyChangeSupport implements java.io.Serializable , Transferable{
    
    public static final DataFlavor CLASS_DATA_FLAVOR=new DataFlavor(Property.class,null);

	private int propertyId;

	private Metadata metadata;

	private String key;
	
	private String value;
	
	public Property() {
	}

	public Property(int propertyId) {
		this.propertyId = propertyId;
	}

	public Property(int propertyId, Metadata metadata, String key, String value) {
		this.propertyId = propertyId;
		this.metadata = metadata;
		this.key = key;
		this.value = value;
	}

	@Id
	@Column(name = "property_id", unique = true, nullable = false)
	//@SequenceGenerator(name="ID_SEQ",sequenceName="id_seq")
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
    public int getPropertyId() {
		return this.propertyId;
	}

	public void setPropertyId(int propertyId) {
		this.propertyId = propertyId;
	}

	@ManyToOne(cascade = {})
	@JoinColumn(name = "metadata_id")
	public Metadata getMetadata() {
		return this.metadata;
	}

	public void setMetadata(Metadata metadata) {
		this.metadata = metadata;
	}

	@Column(name = "key", length = 1000)
	public String getKey() {
		return this.key;
	}

	public void setKey(String key) {
		String oldKey=this.key;
		this.key = key;
		propertyChangeSupport.firePropertyChange("key", oldKey, this.key);
	}

	@Column(name = "value", length = 100000)
	public String getValue() {
		return this.value;
	}

	public void setValue(String value) {
		String oldValue=this.value;
		this.value = value;
		propertyChangeSupport.firePropertyChange("value", oldValue, this.value);
	}
	
	   
    @Transient
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
         if (!isDataFlavorSupported(flavor)) {
             throw new UnsupportedFlavorException(flavor);
         }
         return this;
    }
    @Transient
    public DataFlavor[] getTransferDataFlavors() {
        
        return new DataFlavor[]{CLASS_DATA_FLAVOR};
    }
    @Transient
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return(CLASS_DATA_FLAVOR.equals(flavor));
    }
    
//	public void propertyChange(PropertyChangeEvent evt) {
//		String propName=evt.getPropertyName();
//		String hPropName=ELEMENT_NAME+"."+propName;
//		propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
//	}

}
