/*
 * Date  : 25.03.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

@Entity
@Table(name = "fmt_prompt_doc_element")
@Cacheable
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("prompt")
@PluralResourceKey("prompt")
public class PromptDoc implements Serializable,Cloneable{

	public static final String ELEMENT_NAME="promptdoc"; 
	
	private int id;
	
    @Id
    @Column(name="id", unique = true, nullable = false)
    @ResourceKey("id")
    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
       this.id=id;
    }
	
	private Mediaitem mediaitem;
	
	@MapsId
	@OneToOne
	@JoinColumn(name = "id")
	@XmlTransient
	public Mediaitem getMediaitem() {
		return mediaitem;
	}

	public void setMediaitem(Mediaitem mediaitem) {
		this.mediaitem = mediaitem;
	}
	
//	private Style style;
//	
//	@OneToOne(mappedBy = "promptDoc")
//	public Style getStyle() {
//		return style;
//	}
//
//	public void setStyle(Style style) {
//		this.style = style;
//	}

	private Body body;
	
	@OneToOne(mappedBy = "promptDoc",cascade = {CascadeType.ALL})
    public Body getBody() {
		return body;
	}

	public void setBody(Body body) {
		this.body = body;
	}

	/**
	 * 
	 */
	public PromptDoc() {
		this(null);
	}
	
	public PromptDoc(Element e) {
	    super();
	    if(e!=null){
	    	NodeList childs=e.getChildNodes();
	    	// Look for blocks (only paragraphs for now)
    		for(int ci=0;ci<childs.getLength();ci++){
    			Node n=childs.item(ci);
    			if(n.getNodeType()==Node.ELEMENT_NODE){
    				Element ce=(Element)n;
    				String cen=ce.getTagName();
//    				if(Style.ELEMENT_NAME.equals(cen)){
//    					style=new Style(ce);
//    				}
    				if(Body.ELEMENT_NAME.equals(cen)){
    					body=new Body(ce);
    				}
    			}
    		}
	    }
	}
	
  
	@Transient
	public Element toElement(Document d){
	    Element e=d.createElement(ELEMENT_NAME);
//	    if(style!=null){
//        	e.appendChild(style.toElement(d));
//        }
	    if(body!=null){
        	e.appendChild(body.toElement(d));
        }
		return e;
	}
	
	@Transient
	public Object clone() throws CloneNotSupportedException{
        Object c=super.clone();
        PromptDoc p=(PromptDoc)c;
        return p;
    }
	
	@Transient
	public String toPlainTextString(){
        String pt="";
        if(body!=null) {
            pt=pt.concat(body.toPlainTextString());
        }
        
        return pt;
    }
	
	@Transient
	public String toString(){

		StringBuffer sb=new StringBuffer();
		sb.append("<promptdoc>");
		 if(body!=null) {
	           sb.append(body.toString());
	        }
		sb.append("</promptdoc>");
		return sb.toString();
	}

}
