/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script;

import ipsk.beans.DOMElementConvertible;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMRoot;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Metadata;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Recordingscript;
import ipsk.db.speech.script.ScriptSyntaxException;
import ipsk.db.speech.script.Section;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.persistence.ObjectImmutableIfReferenced;
import ipsk.text.table.ColumnDescriptor;
import ipsk.text.table.TableExportProvider;
import ipsk.text.table.TableExportSchemaProvider;
import ipsk.util.LocalizableMessage;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@DiscriminatorValue(value="script")
@DOMRoot
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="script")
@PluralResourceKey(value="scripts")
@PreferredDisplayOrder(value="scriptId,name,owningProject,projects,metadatasSet,sections,sessions,description")
@XmlType(name="script", namespace="script", propOrder={"name", "description", "sections"})
@XmlRootElement
public class Script
extends Recordingscript
implements Cloneable,
DOMElementConvertible,
TableExportProvider,
ImmutibilityProvider {
    public static final String ELEMENT_NAME = "script";
    public static final String ATT_ID = "id";
    private String name;
    private String description;
    private Metadata metadata = null;
    private Set<Session> sessions = new HashSet<Session>(0);
    private Set<Project> projects = new HashSet<Project>(0);
    private Project owningProject = null;
    private ArrayList<ArrayList<String>> comments = new ArrayList();
    private Element element;
    public static ScriptTableSchemaProvider scriptTableSchemaProvider = new ScriptTableSchemaProvider();

    public Script() {
    }

    public Script(int scriptId, String name) {
        super(scriptId);
        this.name = name;
        this.applyInternalDefaults();
    }

    public Script(IntegerSequenceGenerator seqGen, Element e) throws ScriptSyntaxException {
        this.element = e;
        this.insertElement(seqGen, e);
        this.applyInternalDefaults();
    }

    public Script(Element e) throws ScriptSyntaxException {
        this(null, e);
    }

    @Override
    public void init() {
        super.init();
        this.setName(null);
        this.setDescription(null);
        this.metadata = null;
        this.setSections(null);
        this.comments = new ArrayList();
    }

    @Override
    public void insertElement(IntegerSequenceGenerator seqGen, Element e) throws ScriptSyntaxException {
        this.init();
        super.insertElement(seqGen, (Element)e.getElementsByTagName("recordingscript").item(0));
        String id = e.getAttribute(ATT_ID);
        this.setName(id);
        NodeList childs = e.getChildNodes();
        int ePos = 0;
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                String comm = n.getNodeValue();
                ArrayList<String> pComms = null;
                while (this.comments.size() <= ePos) {
                    this.comments.add(new ArrayList());
                }
                pComms = this.comments.get(ePos);
                pComms.add(comm);
                continue;
            }
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            if (el.getNodeName().equals("metadata")) {
                this.metadata = new Metadata(el);
                this.metadata.setScript(this);
            }
            ++ePos;
        }
    }

    @Column(name="name", nullable=false, length=1000)
    @ResourceKey(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldName, name);
    }

    @Column(name="description", length=10000)
    @ResourceKey(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", oldDescription, this.description);
    }

    @OneToOne(mappedBy="script", cascade={CascadeType.REMOVE})
    @ResourceKey(value="metadata")
    @XmlTransient
    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        Metadata oldMetadata = this.metadata;
        this.metadata = metadata;
        this.propertyChangeSupport.firePropertyChange("metadata", oldMetadata, this.metadata);
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE, CascadeType.MERGE}, mappedBy="script")
    @OrderColumn(name="section_position")
    @ResourceKey(value="sections")
    @XmlElement(name="sections")
    public List<Section> getSections() {
        return super.getSections();
    }

    @Override
    public void setSections(List<Section> sections) {
        super.setSections(sections);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="script")
    @ResourceKey(value="sessions")
    @XmlTransient
    @ObjectImmutableIfReferenced
    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    @ManyToMany(mappedBy="scripts", fetch=FetchType.LAZY)
    @ResourceKey(value="projects")
    @XmlTransient
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="owningProject")
    @ResourceKey(value="project.owning")
    @XmlTransient
    public Project getOwningProject() {
        return this.owningProject;
    }

    public void setOwningProject(Project owningProject) {
        this.owningProject = owningProject;
    }

    public void insertIntoElement(Document d, Element e) {
        ArrayList<String> posCmts;
        Element de = d.getDocumentElement();
        de.setAttribute(ATT_ID, this.getName());
        int ePos = 0;
        if (ePos < this.comments.size() && (posCmts = this.comments.get(ePos)) != null) {
            for (String c : posCmts) {
                de.appendChild(d.createComment(c));
            }
        }
        if (this.metadata != null) {
            de.appendChild(this.metadata.toElement(d));
            ++ePos;
        }
        while (ePos < this.comments.size()) {
            posCmts = this.comments.get(ePos);
            if (posCmts != null) {
                for (String c : posCmts) {
                    de.appendChild(d.createComment(c));
                }
            }
            ++ePos;
        }
        de.appendChild(super.toElement(d));
    }

    @Override
    public Element toElement(Document d) {
        ArrayList<String> posCmts;
        Element e = d.createElement(ELEMENT_NAME);
        e.setAttribute(ATT_ID, this.getName());
        int ePos = 0;
        if (ePos < this.comments.size() && (posCmts = this.comments.get(ePos)) != null) {
            for (String c : posCmts) {
                e.appendChild(d.createComment(c));
            }
        }
        if (this.metadata != null) {
            e.appendChild(this.metadata.toElement(d));
            ++ePos;
        }
        while (ePos < this.comments.size()) {
            posCmts = this.comments.get(ePos);
            if (posCmts != null) {
                for (String c : posCmts) {
                    e.appendChild(d.createComment(c));
                }
            }
            ++ePos;
        }
        e.appendChild(super.toElement(d));
        return e;
    }

    @Override
    public void applyInternalDefaults() {
        super.applyInternalDefaults();
    }

    public void shuffleItems() {
        for (Section sect : this.getSections()) {
            sect.shuffleItems();
        }
    }

    public void apply() {
        for (Section s : this.getSections()) {
            s.apply();
        }
    }

    public void updateUpwardsRelations() {
        for (Section s : this.getSections()) {
            s.setScript(this);
            s.updateUpwardsRelations();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Script cs = (Script)c;
        cs.propertyChangeSupport = new PropertyChangeSupport(this);
        return cs;
    }

    public String toString() {
        return this.name;
    }

    @Transient
    public void defaultSectionMode(Section.Mode defaultSectionMode) {
        List<Section> recSections = this.getSections();
        if (recSections != null) {
            for (Section rs : recSections) {
                rs.setDefaultMode(defaultSectionMode);
            }
        }
    }

    @Transient
    public void defaultSpeakerDisplay(boolean defaultSpeakerDisplay) {
        List<Section> recSections = this.getSections();
        if (recSections != null) {
            for (Section rs : recSections) {
                rs.setDefaultSpeakerDisplay(defaultSpeakerDisplay);
            }
        }
    }

    @Transient
    public void defaultPrerecdelay(int defaultPrerecdelay) {
        List<Section> recSections = this.getSections();
        if (recSections != null) {
            for (Section rs : recSections) {
                rs.defaultPrerecdelay(defaultPrerecdelay);
            }
        }
    }

    @Transient
    public void defaultPostrecdelay(int defaultPostrecdelay) {
        List<Section> recSections = this.getSections();
        if (recSections != null) {
            for (Section rs : recSections) {
                rs.defaultPostrecdelay(defaultPostrecdelay);
            }
        }
    }

    @Transient
    public void defaultAutoplay(boolean defaultAutoplay) {
        List<Section> recSections = this.getSections();
        if (recSections != null) {
            for (Section rs : recSections) {
                rs.defaultAutoplay(defaultAutoplay);
            }
        }
    }

    public List<List<List<String>>> tableData(List<ColumnDescriptor> columns) {
        List<Section> sects = this.getSections();
        ArrayList<List<List<String>>> groups = new ArrayList<List<List<String>>>(sects.size());
        for (Section sect : sects) {
            List<PromptItem> pis = sect.promptItemsList();
            ArrayList group = new ArrayList();
            for (PromptItem pi : pis) {
                if (!(pi instanceof Recording)) continue;
                ArrayList<String> record = new ArrayList<String>();
                Recording r = (Recording)pi;
                for (ColumnDescriptor cd : columns) {
                    String colKeyNm = cd.getKeyName();
                    if ("itemcode".equals(colKeyNm)) {
                        String itemCode = r.getItemcode();
                        record.add(itemCode);
                        continue;
                    }
                    if (!"prompt".equals(colKeyNm)) continue;
                    String descr = r.getDescription();
                    String descrOneLine = descr.replaceAll("\n+", " ");
                    record.add(descrOneLine);
                }
                group.add(record);
            }
            groups.add(group);
        }
        return groups;
    }

    public List<List<List<String>>> tableData() {
        return this.tableData(null);
    }

    @Transient
    public List<PromptItem> promptItemsList() {
        ArrayList<PromptItem> pis = new ArrayList<PromptItem>();
        for (Section s : this.getSections()) {
            List<PromptItem> sectionPis = s.promptItemsList();
            pis.addAll(sectionPis);
        }
        return pis;
    }

    @Override
    @Transient
    public Set<URI> resourceURIs() {
        return super.resourceURIs();
    }

    @Transient
    public Set<URI> absoluteResourceURIs() {
        HashSet<URI> absUris = new HashSet<URI>();
        for (URI ru : this.resourceURIs()) {
            if (!ru.isAbsolute()) continue;
            absUris.add(ru);
        }
        return absUris;
    }

    @Transient
    public boolean hasAbsoluteResourceURIs() {
        Set<URI> absUris = this.absoluteResourceURIs();
        return !absUris.isEmpty();
    }

    @Transient
    public int numberOfPromptItems() {
        return this.promptItemsList().size();
    }

    @Transient
    public Section sectionForItemIndex(int itemIndex) {
        int index = itemIndex;
        List<Section> sections = this.getSections();
        for (Section s : sections) {
            int npis = s.promptItemsList().size();
            if (index >= npis) {
                index -= npis;
                continue;
            }
            return s;
        }
        return null;
    }

    @Transient
    public Integer promptItemIndex(PromptItem pi) {
        List<PromptItem> pis = this.promptItemsList();
        for (int i = 0; i < pis.size(); ++i) {
            PromptItem sPi = pis.get(i);
            if (sPi != pi) continue;
            return i;
        }
        return null;
    }

    @Transient
    public boolean isImmutable() {
        return this.sessions.size() > 0;
    }

    @Transient
    public boolean isRemovable() {
        return !this.isImmutable();
    }

    public static class ScriptTableSchemaProvider
    implements TableExportSchemaProvider {
        public List<ColumnDescriptor> getColumnDescriptors() {
            ColumnDescriptor itCodeDsc = new ColumnDescriptor("itemcode", true, new LocalizableMessage("Item code"));
            ColumnDescriptor promptDsc = new ColumnDescriptor("prompt", true, new LocalizableMessage("Prompt"));
            ArrayList<ColumnDescriptor> colDscs = new ArrayList<ColumnDescriptor>();
            colDscs.add(itCodeDsc);
            colDscs.add(promptDsc);
            return colDscs;
        }

        public boolean isCompleteTableLossless() {
            return false;
        }
    }

    public static enum Scope {
        APPLICATION,
        PROJECT,
        SCRIPT,
        SECTION,
        PROMPTITEM,
        MEDIAITEM;

    }
}

