/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.script.AnnotationTemplate;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.Nonrecording;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.script.prompt.Presenter;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Entity
@Table(name="recording", uniqueConstraints={})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlSeeAlso(value={Recording.class, Nonrecording.class})
public abstract class PromptItem
extends BasicPropertyChangeSupport
implements Serializable,
Cloneable,
Transferable,
ImmutibilityProvider {
    public static final DataFlavor CLASS_DATA_FLAVOR = new DataFlavor(PromptItem.class, null);
    protected int recpromptId;
    private Group group;
    protected Presenter presenter;
    protected List<Mediaitem> mediaitems = new ArrayList<Mediaitem>();
    protected int recscriptIndex;
    private static final Pattern FILENAME_FROM_PATH_PATTERN = Pattern.compile("([^/]*)$");
    protected Integer position;

    public PromptItem() {
    }

    public PromptItem(boolean initialize) {
        if (initialize) {
            // empty if block
        }
    }

    public abstract Element toElement(Document var1);

    @Transient
    public List<String> getMIMETypes() {
        List<Mediaitem> misList = this.getMediaitems();
        ArrayList<String> mimeList = new ArrayList<String>();
        for (Mediaitem mi : misList) {
            mimeList.add(mi.getMimetype());
        }
        return mimeList;
    }

    @Id
    @Column(name="recording_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getRecpromptId() {
        return this.recpromptId;
    }

    public void setRecpromptId(int recpromptId) {
        int oldRecpromptId = this.recpromptId;
        this.recpromptId = recpromptId;
        this.propertyChangeSupport.firePropertyChange("recpromptId", oldRecpromptId, this.recpromptId);
    }

    @ManyToOne
    @JoinColumn(name="group_id")
    @ResourceKey(value="group")
    @XmlTransient
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="recording_mediaitem", joinColumns={@JoinColumn(name="promptitems_recording_id", referencedColumnName="recording_id")})
    @ResourceKey(value="media.item")
    public List<Mediaitem> getMediaitems() {
        return this.mediaitems;
    }

    public void setMediaitems(List<Mediaitem> mediaitems) {
        this.mediaitems = mediaitems;
    }

    @Transient
    public String getDescription() {
        StringBuffer description = new StringBuffer();
        List<Mediaitem> mis = this.getMediaitems();
        int misSize = mis.size();
        for (int i = 0; i < misSize; ++i) {
            Mediaitem mi = mis.get(i);
            if (mi.getAlt() != null) {
                description.append(mi.getAlt());
            } else {
                Matcher matcher;
                String srcPath;
                URI src = mi.getSrc();
                String mimeType = mi.getNNMimetype();
                if (mimeType.startsWith("image")) {
                    description.append("IMAGE: ");
                } else if (mimeType.startsWith("audio")) {
                    description.append("AUDIO: ");
                } else if (mimeType.startsWith("video")) {
                    description.append("VIDEO: ");
                }
                if (mi.getPromptText() != null) {
                    description.append(mi.getPromptText());
                }
                if (src != null && (srcPath = src.getPath()) != null && (matcher = FILENAME_FROM_PATH_PATTERN.matcher(srcPath)).find() && matcher.groupCount() == 1) {
                    String srcFn = matcher.group(1);
                    String srcFnNm = srcFn.replaceFirst("[.][^.]*$", "");
                    description.append(srcFnNm);
                }
            }
            if (i + 1 >= misSize) continue;
            description.append(", ");
        }
        return description.toString();
    }

    @Transient
    @XmlTransient
    public int getRecscriptIndex() {
        return this.recscriptIndex;
    }

    public void setRecscriptIndex(int recscriptIndex) {
        int oldRecscriptIndex = this.recscriptIndex;
        this.recscriptIndex = recscriptIndex;
        this.propertyChangeSupport.firePropertyChange("recscriptIndex", oldRecscriptIndex, this.recscriptIndex);
    }

    @Transient
    protected Mediaitem annotationTemplateMediaitem() {
        for (Mediaitem mi : this.getMediaitems()) {
            if (!mi.getAnnotationTemplate()) continue;
            return mi;
        }
        return null;
    }

    private String annotationTemplateText() {
        String annoTemplTxt;
        Recording thisR;
        AnnotationTemplate annoTempl;
        if (this instanceof Recording && (annoTempl = (thisR = (Recording)this).getAnnotationTemplate()) != null && (annoTemplTxt = annoTempl.getAnnotationtemplate()) != null) {
            return annoTemplTxt;
        }
        Mediaitem ami = this.annotationTemplateMediaitem();
        String amiTxt = null;
        if (ami != null) {
            amiTxt = ami.getText();
        }
        return amiTxt;
    }

    public LocalizedText annotationTemplateLocalizedText() {
        String annoTemplTxt;
        Recording thisR;
        AnnotationTemplate annoTempl;
        if (this instanceof Recording && (annoTempl = (thisR = (Recording)this).getAnnotationTemplate()) != null && (annoTemplTxt = annoTempl.getAnnotationtemplate()) != null) {
            Locale lLoc = null;
            String langCode = annoTempl.getLanguageISO639code();
            if (langCode != null && !langCode.isEmpty()) {
                String countryCode = annoTempl.getCountryISO3166code();
                lLoc = countryCode != null && !countryCode.isEmpty() ? new Locale(langCode, countryCode) : new Locale(langCode);
            }
            LocalizedText lt = new LocalizedText(annoTemplTxt, lLoc);
            return lt;
        }
        Mediaitem ami = this.annotationTemplateMediaitem();
        String amiTxt = null;
        if (ami != null && (amiTxt = ami.getText()) != null) {
            Locale lLoc = null;
            String langCode = ami.getLanguageISO639code();
            if (langCode != null && !langCode.isEmpty()) {
                String countryCode = ami.getCountryISO3166code();
                lLoc = countryCode != null && !countryCode.isEmpty() ? new Locale(langCode, countryCode) : new Locale(langCode);
            }
            LocalizedText lt = new LocalizedText(amiTxt, lLoc);
            return lt;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        PromptItem pi = (PromptItem)c;
        pi.propertyChangeSupport = new PropertyChangeSupport(this);
        List<Mediaitem> mis = this.mediaitems;
        ArrayList<Mediaitem> cMis = new ArrayList<Mediaitem>();
        for (Mediaitem mi : mis) {
            Mediaitem cMi = (Mediaitem)mi.clone();
            cMis.add(cMi);
        }
        pi.mediaitems = cMis;
        return pi;
    }

    @Override
    @Transient
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    @Override
    @Transient
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CLASS_DATA_FLAVOR};
    }

    @Override
    @Transient
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return CLASS_DATA_FLAVOR.equals(flavor);
    }

    @Transient
    @XmlTransient
    public Presenter getPresenter() {
        return this.presenter;
    }

    public void setPresenter(Presenter presenter) {
        this.presenter = presenter;
    }

    @Transient
    public Set<URI> resourceURIs() {
        HashSet<URI> usedUris = new HashSet<URI>();
        for (Mediaitem mi : this.mediaitems) {
            URI srcUri = mi.getSrc();
            if (srcUri == null) continue;
            usedUris.add(srcUri);
        }
        return usedUris;
    }

    @Transient
    public void defaultAutoplay(boolean defaultAutoplay) {
        for (Mediaitem mi : this.mediaitems) {
            mi.setDefaultAutoplay(defaultAutoplay);
        }
    }

    protected void apply() {
        for (Mediaitem mi : this.mediaitems) {
            mi.apply();
        }
    }

    @Transient
    public boolean isImmutable() {
        Group g = this.getGroup();
        return g != null && g.isImmutable();
    }

    @Transient
    public boolean isRemovable() {
        return !this.isImmutable();
    }

    public void defaultVirtualViewBox(VirtualViewBox defaultVirtualViewBox) {
        for (Mediaitem mi : this.mediaitems) {
            mi.setDefaultVirtualViewBox(defaultVirtualViewBox);
        }
    }
}

