/*
 * Date  : 25.03.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

@Entity
@DiscriminatorValue("paragraph")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("paragraph")
@PluralResourceKey("paragraphs")
public class P extends Block{

	public static final String ELEMENT_NAME="p"; 
	
    /**
	 * 
	 */
	public P() {
		this(null);
	}
	
	public P(Element e) {
	    super();
	    if(e!=null){

	        NodeList textElList=e.getChildNodes();
	        for(int i=0;i<textElList.getLength();i++){

	            Node tn=textElList.item(i);
	            if(tn instanceof Element){
	                Element te=(Element)tn;
	                String teTgNm=te.getTagName();
	                if(Font.ELEMENT_NAME.equals(teTgNm)){
	                    Font f=new Font(te);
	                    texts.add(f);
	                }else if(Text.ELEMENT_NAME.equals(teTgNm)){
	                    Text t=new Text(te);
	                    texts.add(t);
	                }else if(Linebreak.ELEMENT_NAME.equals(teTgNm)){
	                	Linebreak nl=new Linebreak();
	                    texts.add(nl);
	                }
	            }
	        }
	    }
	}
	
	@Transient
	public Element toElement(Document d){
	    Element e=d.createElement(ELEMENT_NAME);
	    for(TextFormatElement te:texts){
	        e.appendChild(te.toElement(d));
	    }
		return e;
	}
	
	@Transient
	public Object clone() throws CloneNotSupportedException{
        Object c=super.clone();
        P p=(P)c;
        return p;
    }
	
	@Transient
	public String toPlainTextString(){

        StringBuffer sb=new StringBuffer();
       
        for(TextFormatElement ft:texts){
            sb.append(ft.toPlainTextString());
        }
        sb.append('\n');
        return sb.toString();
    }
	
	@Transient
	public String toString(){

		StringBuffer sb=new StringBuffer();
		sb.append("<"+ELEMENT_NAME+">");
		for(TextFormatElement ft:texts){
			sb.append(ft.toString());
		}
		sb.append("</"+ELEMENT_NAME+">");
		return sb.toString();
	}

}
