/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.HiddenProperties;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Message;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Person;
import ipsk.db.speech.Project;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.UserRole;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="account")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="account")
@HiddenProperties(value={"password", "sha5HexPassword", "rfc2307Password", "strongPassword", "editable"})
@PreferredDisplayOrder(value="login,loginCaseInsensitiv,created,userRoles,email,organisation,person,adminOfProjects,projects")
@NamedQuery(name="account.byLogin", query="SELECT acc FROM Account acc WHERE acc.login = ?1")
public class Account
implements Serializable,
ImmutibilityProvider {
    private String login;
    private boolean loginCaseInsensitiv = false;
    private String email;
    private Organisation organisation;
    private Person person;
    private Set<Project> projects = new HashSet<Project>(0);
    private Set<Speaker> registeredSpeakers = new HashSet<Speaker>(0);
    private String password;
    private String sha5HexPassword;
    private String rfc2307Password;
    private String strongPassword;
    private boolean editable = true;
    private Date created = new Date();
    private Set<UserRole> userRoles = new HashSet<UserRole>(0);
    private Set<Message> messagesForToLogin = new HashSet<Message>(0);
    private Set<Message> messagesForFromLogin = new HashSet<Message>(0);
    private Set<Project> adminOfProjects = new HashSet<Project>(0);

    @Column(name="rfc2307_password", length=46)
    @ResourceKey(value="password.rfc2307")
    @XmlTransient
    public String getRfc2307Password() {
        return this.rfc2307Password;
    }

    public void setRfc2307Password(String rfc2307Password) {
        this.rfc2307Password = rfc2307Password;
    }

    @Column(name="strong_password", length=64)
    @ResourceKey(value="password.strong")
    @XmlTransient
    public String getStrongPassword() {
        return this.strongPassword;
    }

    public void setStrongPassword(String strongPassword) {
        this.strongPassword = strongPassword;
    }

    public Account() {
        this.created = new Date();
    }

    public Account(String login) {
        this();
        this.login = login;
    }

    @Id
    @Column(name="login", unique=true, nullable=false, length=100)
    @ResourceKey(value="login")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="loginCaseInsensitiv")
    @ResourceKey(value="case_insensitive")
    public boolean isLoginCaseInsensitiv() {
        return this.loginCaseInsensitiv;
    }

    public void setLoginCaseInsensitiv(boolean loginCaseInsensitiv) {
        this.loginCaseInsensitiv = loginCaseInsensitiv;
    }

    @Column(length=1000)
    @ResourceKey(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="organisation_id")
    @ResourceKey(value="organisation")
    @XmlTransient
    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    @OneToOne
    @JoinColumn(name="person_id")
    @ResourceKey(value="person")
    @XmlTransient
    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    @XmlTransient
    @Transient
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="sha5_hex_password", length=128)
    @ResourceKey(value="password.sha5")
    @XmlTransient
    public String getSha5HexPassword() {
        return this.sha5HexPassword;
    }

    public void setSha5HexPassword(String sha5HexPassword) {
        this.sha5HexPassword = sha5HexPassword;
    }

    @Column(name="created", nullable=false, updatable=false)
    @ResourceKey(value="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    @Column(name="editable")
    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.PERSIST}, mappedBy="account")
    @ResourceKey(value="user_roles")
    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="accountByToLogin")
    @ResourceKey(value="msgs.to")
    @XmlTransient
    public Set<Message> getMessagesForToLogin() {
        return this.messagesForToLogin;
    }

    public void setMessagesForToLogin(Set<Message> messagesForToLogin) {
        this.messagesForToLogin = messagesForToLogin;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="accountByFromLogin")
    @ResourceKey(value="msgs.from")
    @XmlTransient
    public Set<Message> getMessagesForFromLogin() {
        return this.messagesForFromLogin;
    }

    public void setMessagesForFromLogin(Set<Message> messagesForFromLogin) {
        this.messagesForFromLogin = messagesForFromLogin;
    }

    @ManyToMany(mappedBy="accounts")
    @ResourceKey(value="projects")
    @XmlIDREF
    public Set<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(Set<Project> projects) {
        this.projects = projects;
    }

    @ManyToMany(mappedBy="adminAccounts")
    @ResourceKey(value="admin.projects")
    @XmlIDREF
    public Set<Project> getAdminOfProjects() {
        return this.adminOfProjects;
    }

    public void setAdminOfProjects(Set<Project> adminOfProjects) {
        this.adminOfProjects = adminOfProjects;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="registeredByAccount")
    @ResourceKey(value="registered_speakers")
    @XmlTransient
    public Set<Speaker> getRegisteredSpeakers() {
        return this.registeredSpeakers;
    }

    public void setRegisteredSpeakers(Set<Speaker> registeredSpeakers) {
        this.registeredSpeakers = registeredSpeakers;
    }

    @Transient
    public Set<Project> associatedProjects() {
        HashSet<Project> assProjs = new HashSet<Project>(0);
        assProjs.addAll(this.getProjects());
        if (this.person != null) {
            Set<Organisation> organisations = this.person.getOrganisations();
            for (Organisation orga : organisations) {
                assProjs.addAll(orga.getProjects());
            }
        } else if (this.organisation != null) {
            return this.organisation.getProjects();
        }
        return assProjs;
    }

    @Transient
    public Set<Organisation> associatedOrganisations() {
        HashSet<Organisation> assOrgas = new HashSet<Organisation>(0);
        if (this.person != null) {
            return this.person.getOrganisations();
        }
        if (this.organisation != null) {
            assOrgas.add(this.organisation);
        }
        return assOrgas;
    }

    @Transient
    public String getDisplayString() {
        Person p = this.getPerson();
        if (p != null) {
            return this.getLogin() + ": " + p.toString();
        }
        Organisation orga = this.getOrganisation();
        if (orga != null) {
            return this.getLogin() + ": " + orga.toString();
        }
        return this.toString();
    }

    @Transient
    public String contactEmail() {
        String email = this.getEmail();
        if (email == null) {
            Organisation orga;
            Person p = this.getPerson();
            if (p != null) {
                email = p.getEmail();
            }
            if (email == null && (orga = this.getOrganisation()) != null) {
                email = orga.getEmail();
            }
        }
        return email;
    }

    public String toString() {
        return this.getLogin();
    }

    @Transient
    public boolean isImmutable() {
        return !this.editable;
    }

    @Transient
    public boolean isRemovable() {
        return true;
    }
}

