/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script;

import ipsk.beans.DOMElementConvertible;
import ipsk.beans.LinkID;
import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.XMLIntegerAdapter;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.ScriptSyntaxException;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.util.ResourceKey;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="script")
@Cacheable
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorValue(value="recscript")
@XmlSeeAlso(value={Script.class})
public class Recordingscript
extends BasicPropertyChangeSupport
implements Serializable,
PropertyChangeListener,
DOMElementConvertible {
    protected static final String ELEMENT_NAME = "recordingscript";
    protected Integer scriptId;
    private List<Section> sections = new ArrayList<Section>();
    private ArrayList<ArrayList<String>> comments = new ArrayList();
    private boolean propertyChangeSupportEnabled = false;
    private VirtualViewBox virtualViewBox;

    @Transient
    @XmlTransient
    public boolean isPropertyChangeSupportEnabled() {
        return this.propertyChangeSupportEnabled;
    }

    public void setPropertyChangeSupportEnabled(boolean propertyChangeSupportEnabled) {
        this.propertyChangeSupportEnabled = propertyChangeSupportEnabled;
    }

    public Recordingscript() {
    }

    public Recordingscript(int scriptId) {
        this();
        this.scriptId = scriptId;
    }

    public Recordingscript(IntegerSequenceGenerator seqgen, Element e) throws ScriptSyntaxException {
        this.insertElement(seqgen, e);
    }

    public void setVirtualViewBox(VirtualViewBox virtualViewBox) {
        this.virtualViewBox = virtualViewBox;
    }

    @ResourceKey(value="virtualviewbox")
    @OneToOne(mappedBy="recordingscript", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    public VirtualViewBox getVirtualViewBox() {
        return this.virtualViewBox;
    }

    public void init() {
        this.sections = new ArrayList<Section>();
        this.comments = new ArrayList();
    }

    public Set<List<String>> requiredMIMETypeCombinations() {
        HashSet<List<String>> reqMIMETypes = new HashSet<List<String>>();
        List<Section> secList = this.getSections();
        for (Section sec : secList) {
            Set<List<String>> reqMimesForSec = sec.requiredMIMETypeCombinations();
            reqMIMETypes.addAll(reqMimesForSec);
        }
        return reqMIMETypes;
    }

    protected void insertElement(IntegerSequenceGenerator seqGen, Element e) throws ScriptSyntaxException {
        if (seqGen != null) {
            this.setScriptId(seqGen.getAndIncrement());
        }
        NodeList childs = e.getChildNodes();
        ArrayList<Section> sectionsList = new ArrayList<Section>();
        int ePos = 0;
        boolean sectionPos = false;
        for (int ci = 0; ci < childs.getLength(); ++ci) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                String comm = n.getNodeValue();
                ArrayList<String> pComms = null;
                while (this.comments.size() <= ePos) {
                    this.comments.add(new ArrayList());
                }
                pComms = this.comments.get(ePos);
                pComms.add(comm);
                continue;
            }
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            String elName = el.getNodeName();
            if ("virtualviewbox".equals(elName)) {
                this.virtualViewBox = new VirtualViewBox(el);
            } else if (elName.equals("section")) {
                Section sectionFromElement = new Section(seqGen, el);
                if (this instanceof Script) {
                    sectionFromElement.setScript((Script)this);
                }
                sectionFromElement.setPropertyChangeSupportEnabled(true);
                sectionsList.add(sectionFromElement);
            }
            ++ePos;
        }
        this.setSections(sectionsList);
    }

    protected void applyInternalDefaults() {
        for (Section sect : this.getSections()) {
            sect.defaultVirtualViewBox(this.virtualViewBox);
        }
    }

    @Id
    @Column(name="script_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @LinkID
    @XmlID
    @XmlJavaTypeAdapter(value=XMLIntegerAdapter.class)
    @ResourceKey(value="id")
    public Integer getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(Integer scriptId) {
        Integer oldScriptId = this.scriptId;
        this.scriptId = scriptId;
        this.propertyChangeSupport.firePropertyChange("scriptId", oldScriptId, scriptId);
    }

    @Transient
    public Set<String> itemCodesSet() {
        HashSet<String> ics = new HashSet<String>();
        for (Section s : this.sections) {
            Set<String> sIcs = s.itemCodesSet();
            ics.addAll(sIcs);
        }
        return ics;
    }

    @Transient
    public List<String> itemCodesList() {
        ArrayList<String> icl = new ArrayList<String>();
        for (Section s : this.sections) {
            List<String> sIcl = s.itemCodesList();
            icl.addAll(sIcl);
        }
        return icl;
    }

    public Element toElement(Document d) {
        ArrayList<String> posCmts;
        int ePos;
        List<Section> sectionsList;
        Element e = d.createElement(ELEMENT_NAME);
        if (this.virtualViewBox != null) {
            e.appendChild(this.virtualViewBox.toElement(d));
        }
        if ((sectionsList = this.getSections()) != null) {
            for (ePos = 0; ePos < sectionsList.size(); ++ePos) {
                if (ePos < this.comments.size() && (posCmts = this.comments.get(ePos)) != null) {
                    for (String c : posCmts) {
                        e.appendChild(d.createComment(c));
                    }
                }
                Section s = sectionsList.get(ePos);
                e.appendChild(s.toElement(d));
            }
        }
        while (ePos < this.comments.size()) {
            posCmts = this.comments.get(ePos);
            if (posCmts != null) {
                for (String c : posCmts) {
                    e.appendChild(d.createComment(c));
                }
            }
            ++ePos;
        }
        return e;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="script")
    @OrderColumn(name="section_position")
    @ResourceKey(value="sections")
    @XmlTransient
    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> sections) {
        List<Section> oldSections = null;
        if (this.propertyChangeSupportEnabled && (oldSections = this.sections) != null) {
            for (Section os : oldSections) {
                os.setScript(null);
                os.removePropertyChangeListener(this);
            }
        }
        this.sections = sections;
        if (this.propertyChangeSupportEnabled) {
            if (this.sections != null) {
                for (Section os : this.sections) {
                    if (this instanceof Script) {
                        os.setScript((Script)this);
                    }
                    os.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            String propName = evt.getPropertyName();
                            String hPropName = "sections." + propName;
                            Recordingscript.this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
                        }
                    });
                }
            }
            this.propertyChangeSupport.firePropertyChange("sections", oldSections, sections);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "recordingscript." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }

    @Transient
    public boolean recordingCodesUnique() {
        List<String> dics = this.duplicateItemCodes();
        return dics.size() == 0;
    }

    @Transient
    public List<String> duplicateItemCodes() {
        List<String> itemCodesList = this.itemCodesList();
        HashSet<String> existingItemCodesSet = new HashSet<String>();
        ArrayList<String> duplicateItemCodes = new ArrayList<String>();
        for (String ic : itemCodesList) {
            if (existingItemCodesSet.contains(ic) && !duplicateItemCodes.contains(ic)) {
                duplicateItemCodes.add(ic);
                continue;
            }
            existingItemCodesSet.add(ic);
        }
        return duplicateItemCodes;
    }

    @Transient
    public boolean needsSilenceDetector() {
        for (Section s : this.sections) {
            if (!s.needsSilenceDetector()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public boolean needsBeep() {
        for (Section s : this.sections) {
            if (!s.needsBeep()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public Set<URI> resourceURIs() {
        HashSet<URI> usedUris = new HashSet<URI>();
        for (Section se : this.getSections()) {
            usedUris.addAll(se.resourceURIs());
        }
        return usedUris;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Recordingscript crs = (Recordingscript)c;
        crs.propertyChangeSupport = new PropertyChangeSupport(this);
        List<Section> sections = this.sections;
        ArrayList<Section> csections = new ArrayList<Section>();
        for (Section s : sections) {
            Section cS = (Section)s.clone();
            csections.add(cS);
        }
        crs.sections = csections;
        return crs;
    }
}

