/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script.prompt.doc;

import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Font;
import ipsk.db.speech.script.prompt.doc.Linebreak;
import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.db.speech.script.prompt.doc.TextFormatElement;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import javax.persistence.Cacheable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Cacheable
@DiscriminatorValue(value="paragraph")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="paragraph")
@PluralResourceKey(value="paragraphs")
public class P
extends Block {
    public static final String ELEMENT_NAME = "p";

    public P() {
        this(null);
    }

    public P(Element e) {
        if (e != null) {
            NodeList textElList = e.getChildNodes();
            for (int i = 0; i < textElList.getLength(); ++i) {
                Node tn = textElList.item(i);
                if (!(tn instanceof Element)) continue;
                Element te = (Element)tn;
                String teTgNm = te.getTagName();
                if ("font".equals(teTgNm)) {
                    Font f = new Font(te);
                    this.texts.add(f);
                    continue;
                }
                if ("text".equals(teTgNm)) {
                    Text t = new Text(te);
                    this.texts.add(t);
                    continue;
                }
                if (!"br".equals(teTgNm)) continue;
                Linebreak nl = new Linebreak();
                this.texts.add(nl);
            }
        }
    }

    @Override
    @Transient
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        for (TextFormatElement te : this.texts) {
            e.appendChild(te.toElement(d));
        }
        return e;
    }

    @Transient
    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        P p = (P)c;
        return p;
    }

    @Override
    @Transient
    public String toPlainTextString() {
        StringBuffer sb = new StringBuffer();
        for (TextFormatElement ft : this.texts) {
            sb.append(ft.toPlainTextString());
        }
        sb.append('\n');
        return sb.toString();
    }

    @Transient
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<p>");
        for (TextFormatElement ft : this.texts) {
            sb.append(ft.toString());
        }
        sb.append("</p>");
        return sb.toString();
    }
}

