package ipsk.db.speech;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@Entity(name = "conditional_client_config")
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@ResourceBundleName("ipsk.db.speech.PropertyNames")
public class ConditionalClientConfig {

	public static enum Platform {LINUX,MACOS,WINDOWS,ANDROID}
	//public static enum BrowserBase {CHROMIUM};
	//public static enum Browser {FIREFOX,CHROMIUM,CHROME,EDGE,OPERA}
	
	private int id;
	
	@Id
	@Column(name = "id", unique = true, nullable = false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	private Platform platform=null;
//	private BrowserBase browserBase=null;
//	private Browser browser=null;
	
	public ConditionalClientConfig() {
		
	}

	@Column
	@Enumerated(EnumType.STRING)
	@ResourceKey("platform")
	public Platform getPlatform() {
		return platform;
	}

	public void setPlatform(Platform platform) {
		this.platform = platform;
	}

//	@Enumerated(EnumType.STRING)
//	public BrowserBase getBrowserBase() {
//		return browserBase;
//	}
//
//	public void setBrowserBase(BrowserBase browserBase) {
//		this.browserBase = browserBase;
//	}
//
//	@Enumerated(EnumType.STRING)
//	public Browser getBrowser() {
//		return browser;
//	}
//
//	public void setBrowser(Browser browser) {
//		this.browser = browser;
//	}
//	
}
