/*
 * Date  : 05.11.2014
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * XML adapter class for integers.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class XMLIntegerAdapter extends XmlAdapter<String, Integer> {
    
    
    public XMLIntegerAdapter(){
        super();
    }
    
    public String marshal(Integer i) throws Exception {
    	if(i==null){
    		return null;
    	}
        return i.toString();
    }

    public Integer unmarshal(String iString) throws Exception {
    	if(iString==null){
    		return null;
    	}
    	return Integer.parseInt(iString);
    }
}
