//    IPS Java Speech Database
//    (c) Copyright 2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Speech Database
//
//
//    IPS Java Speech Database is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Speech Database is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Speech Database.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.db.speech.project;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * Media stream constraints
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("media.stream.constraints")
public class MediaStreamConstraints {
	
	
	public static enum ConstraintType {EXACT,IDEAL}
	
	@Embeddable
	public static class BooleanConstraint{
		private boolean value;

		public boolean getValue() {
			return value;
		}

		public void setValue(boolean value) {
			this.value = value;
		}
		
		private ConstraintType constraintType=ConstraintType.EXACT;

		@Enumerated(EnumType.STRING)
		public ConstraintType getConstraintType() {
			return constraintType;
		}

		public void setConstraintType(ConstraintType constraintType) {
			this.constraintType = constraintType;
		}
	}

}
