/*
 * Date  : 03.04.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@Entity
@Table(name = "fmt_prompt_block_element")
@Cacheable
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlSeeAlso({P.class})
public abstract class  Block implements Serializable{

	protected int blockId;
	
	@Id
	@Column(name = "block_id", unique = true, nullable = false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
	@XmlTransient
	public int getBlockId() {
		return blockId;
	}

	public void setBlockId(int blockId) {
		this.blockId = blockId;
	}

	private Body body;
	
	@ManyToOne
	@XmlTransient
	public Body getBody() {
		return body;
	}

	public void setBody(Body body) {
		this.body = body;
	}

	protected List<TextFormatElement> texts=new ArrayList<TextFormatElement>();

	@OneToMany(mappedBy = "block",cascade = CascadeType.ALL)
	@OrderColumn(name="fmt_text_el_position")
	public List<TextFormatElement> getTexts() {
        return texts;
    }

    public void setTexts(List<TextFormatElement> texts) {
        this.texts = texts;
    }

	public abstract Element toElement(Document d);

    public abstract String toPlainTextString();
	
}
