/*
 * Date  : 25.03.2017
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ipsk.db.speech.script.prompt.doc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

@Entity
@Table(name = "fmt_prompt_body_element")
@Cacheable
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("body")
@PluralResourceKey("body")
public class Body implements Serializable,Cloneable{

	public static final String ELEMENT_NAME="body"; 
	
	private int id;
	
	  @Id
	    @Column(name="id", unique = true, nullable = false)
	    @ResourceKey("id")
	    @XmlTransient
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	private PromptDoc promptDoc;
	
		@OneToOne
		@MapsId
		@JoinColumn(name="id")
		@XmlTransient
		public PromptDoc getPromptDoc() {
			return promptDoc;
		}
	
		public void setPromptDoc(PromptDoc promptDoc) {
			this.promptDoc = promptDoc;
		}

	private List<Block> blocks=new ArrayList<Block>();
	
	
	
    /**
	 * 
	 */
	public Body() {
		this(null);
	}
	
	public Body(Element e) {
	    super();
	    if(e!=null){
	    	NodeList childs=e.getChildNodes();
	    	// Look for blocks (only paragraphs for now)
    		for(int ci=0;ci<childs.getLength();ci++){
    			Node n=childs.item(ci);
    			if(n.getNodeType()==Node.ELEMENT_NODE){
    				Element ce=(Element)n;
    				String cen=ce.getTagName();
    				if("p".equals(cen)){
    					P p=new P(ce);
    					blocks.add(p);
    					
    				}
    			}
    		}
	    }
	}
	
    //@OneToMany(mappedBy = "promptDocBody",cascade = CascadeType.ALL)
    @OneToMany(mappedBy = "body",cascade = CascadeType.ALL)
    @OrderColumn(name="block_position")
    public List<Block> getBlocks() {
    	return blocks;
    }

    public void setBlocks(List<Block> blocks) {
    	this.blocks = blocks;
    }

	
	@Transient
	public Element toElement(Document d){
	    Element e=d.createElement(ELEMENT_NAME);
	    if(blocks!=null){
        	for(Block blk:blocks){
        		Element blkE=blk.toElement(d);
        		e.appendChild(blkE);
        	}
        }
		return e;
	}
	
	@Transient
	public Object clone() throws CloneNotSupportedException{
        Object c=super.clone();
        Body p=(Body)c;
        return p;
    }
	
	@Transient
	public String toPlainTextString(){
        String pt="";
        for(Block block:blocks){
            pt=pt.concat(block.toPlainTextString());
        }
        return pt;
    }
	
	@Transient
	public String toString(){

		StringBuffer sb=new StringBuffer();
		sb.append("<"+ELEMENT_NAME+">");
		 for(Block block:blocks){
	           sb.append(block.toString());
	        }
		sb.append("</"+ELEMENT_NAME+">");
		return sb.toString();
	}

}
