/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.project;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.Unit;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="media_capture_format", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="media.capture.format")
@PreferredDisplayOrder(value="audioChannelCount,audioSampleRate,audioQuantisationBits")
public class MediaCaptureFormat {
    private String name;
    private Project project;
    private int audioChannelCount = 2;
    private double audioSampleRate = 44100.0;
    private int audioQuantisationBits = 16;

    @Id
    @Column(nullable=false)
    @ResourceKey(value="name")
    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MapsId
    @OneToOne
    @JoinColumn(name="name")
    @XmlTransient
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Column(name="audioChannelCount")
    @ResourceKey(value="channels")
    public int getAudioChannelCount() {
        return this.audioChannelCount;
    }

    @Column(name="audioSamplerate")
    @ResourceKey(value="samplerate")
    @Unit(value="Hz")
    public double getAudioSampleRate() {
        return this.audioSampleRate;
    }

    @Column(name="audioQuantisationBits")
    @ResourceKey(value="quantisation")
    public int getAudioQuantisationBits() {
        return this.audioQuantisationBits;
    }

    public void setAudioChannelCount(int channelCount) {
        this.audioChannelCount = channelCount;
    }

    public void setAudioSampleRate(double d) {
        this.audioSampleRate = d;
    }

    public void setAudioQuantisationBits(int quantisation) {
        this.audioQuantisationBits = quantisation;
    }

    public String toString() {
        return "Audio: " + this.audioChannelCount + " Chs, " + this.audioSampleRate + " Hz, " + this.audioQuantisationBits + " bits";
    }
}

