/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElements;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Account;
import ipsk.db.speech.AudioDevice;
import ipsk.db.speech.AudioFormat;
import ipsk.db.speech.DialectRegion;
import ipsk.db.speech.FormConfiguration;
import ipsk.db.speech.InformedConsent;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Session;
import ipsk.db.speech.SpeechRecorderClient;
import ipsk.db.speech.account.InvitationRequest;
import ipsk.db.speech.project.AutoGainControlConfig;
import ipsk.db.speech.project.LocalizedDefaultPurposeText;
import ipsk.db.speech.project.LocalizedInformedConsentText;
import ipsk.db.speech.project.MediaCaptureFormat;
import ipsk.db.speech.script.Script;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.TooltipResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Entity
@Table(name="project", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="project")
@PluralResourceKey(value="projects")
@PreferredDisplayOrder(value="name,uuid,description,registered,registeredByAccount,defaultResearchPurpose,defaultResearchPurposeLanguageISO3code,defaultResearchPurposeAdditionalLanguages,defaultInformedConsentText,defaultInformedConsentTextFormat,defaultInformedConsentTextLanguageISO3code,informedConsentTextAdditionalLanguages,enableBroadConsent,organisations,dialectRegions,scriptSelectionMode,recordingDeviceWakeLock,audioDevices,chunkedRecording,clientAudioStorageType,ownedForms,ownedScripts,scripts,showSessionCompleteMessage,allowPublicPseudonymizedAudioExport,*")
@DOMAttributes(value={"name"})
@DOMElements(value={"description", "audioFormat", "sessionCode", "organisations"})
@XmlType(name="project", propOrder={"name", "uuid", "registered", "description", "defaultResearchPurpose", "defaultResearchPurposeLanguageISO3code", "defaultResearchPurposeAdditionalLanguages", "defaultInformedConsentText", "defaulInformedConsentTextFormat", "defaultInformedConsentTextLanguageISO3code", "informedConsentTextAdditionalLanguages", "enableBroadConsent", "informedConsentPaperForm", "scriptSelectionMode", "recordingDeviceWakeLock", "mediaCaptureFormat", "audioFormat", "audioDevices", "autoGainControlConfigs", "allowEchoCancellation", "chunkedRecording", "clientAudioStorageType", "speakerFormConfiguration", "showSessionCompleteMessage", "exportFormatVersion", "allowPublicPseudonymizedAudioExport", "speakerWindowShowStopRecordAction"})
@XmlRootElement
public class Project
implements Serializable {
    private String name;
    private String uuid;
    private Date registered = new Date();
    private Account registeredByAccount;
    private String contextPath;
    private String description;
    private AudioFormat audioFormat;
    private MediaCaptureFormat mediaCaptureFormat;
    private List<AutoGainControlConfig> autoGainControlConfigs = new ArrayList<AutoGainControlConfig>();
    private Boolean allowEchoCancellation = null;
    private AudioStorageType clientAudioStorageType = null;
    private String sessionCode;
    private ScriptSelectionMode scriptSelectionMode;
    private String defaultResearchPurpose;
    private String defaultResearchPurposeLanguageISO3code;
    private List<LocalizedDefaultPurposeText> defaultResearchPurposeAdditionalLanguages = new ArrayList<LocalizedDefaultPurposeText>();
    private String defaultInformedConsentText;
    private TextFormat defaultInformedConsentTextFormat = null;
    private String defaultInformedConsentTextLanguageISO3code;
    private List<LocalizedInformedConsentText> informedConsentTextAdditionalLanguages = new ArrayList<LocalizedInformedConsentText>();
    private boolean enableBroadConsent = false;
    private Integer exportFormatVersion = 1;
    private Set<Account> adminAccounts = new HashSet<Account>(0);
    private Set<Account> accounts = new HashSet<Account>(0);
    private Set<Session> sessions = new HashSet<Session>(0);
    private Set<InformedConsent> informedConsents = new HashSet<InformedConsent>(0);
    private Set<DialectRegion> dialectRegions = new HashSet<DialectRegion>(0);
    private List<SpeechRecorderClient> allowedSpeechRecorderClients = new ArrayList<SpeechRecorderClient>();
    private List<AudioDevice> audioDevices = new ArrayList<AudioDevice>(0);
    private Set<Organisation> organisations = new HashSet<Organisation>(0);
    private Set<InvitationRequest> invitationRequests = new HashSet<InvitationRequest>();
    private Set<Script> ownedScripts = new HashSet<Script>();
    private Set<FormConfiguration> ownedForms = new HashSet<FormConfiguration>();
    private Set<Script> scripts = new HashSet<Script>(0);
    private boolean speakerWindowShowStopRecordAction = true;
    private boolean showSessionCompleteMessage = true;
    private Boolean recordingDeviceWakeLock = null;
    private Boolean chunkedRecording = null;
    private boolean informedConsentPaperForm = false;
    private FormConfiguration speakerFormConfiguration;
    private boolean allowPublicPseudonymizedAudioExport = false;
    private Date lastVisitOfProjectAdmin = null;

    @OneToOne(mappedBy="project", cascade={CascadeType.REMOVE})
    @ResourceKey(value="media.capture.format")
    @TooltipResourceKey(value="media.capture.format.tooltip")
    public MediaCaptureFormat getMediaCaptureFormat() {
        return this.mediaCaptureFormat;
    }

    public void setMediaCaptureFormat(MediaCaptureFormat audioCaptureFormat) {
        this.mediaCaptureFormat = audioCaptureFormat;
    }

    @ResourceKey(value="configs.auto_gain_control")
    @TooltipResourceKey(value="configs.auto_gain_control.tooltip")
    @OneToMany(mappedBy="project", cascade={CascadeType.REMOVE})
    public List<AutoGainControlConfig> getAutoGainControlConfigs() {
        return this.autoGainControlConfigs;
    }

    public void setAutoGainControlConfigs(List<AutoGainControlConfig> autoGainControlConfigs) {
        this.autoGainControlConfigs = autoGainControlConfigs;
    }

    @ResourceKey(value="recording.allowEchoCancellation")
    public Boolean getAllowEchoCancellation() {
        return this.allowEchoCancellation;
    }

    public void setAllowEchoCancellation(Boolean allowEchoCancellation) {
        this.allowEchoCancellation = allowEchoCancellation;
    }

    @Column(name="client_audio_storage_type", length=32)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="client.audio.storage.type")
    @TooltipResourceKey(value="client.audio.storage.type.tooltip")
    public AudioStorageType getClientAudioStorageType() {
        return this.clientAudioStorageType;
    }

    public void setClientAudioStorageType(AudioStorageType clientAudioStorageType) {
        this.clientAudioStorageType = clientAudioStorageType;
    }

    @Column(name="default_informed_consent_text_format", length=32)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="consent.informed.text.default.format")
    @TooltipResourceKey(value="consent.informed.text.default.format.tooltip")
    public TextFormat getDefaultInformedConsentTextFormat() {
        return this.defaultInformedConsentTextFormat;
    }

    public void setDefaultInformedConsentTextFormat(TextFormat defaultInformedConsentTextFormat) {
        this.defaultInformedConsentTextFormat = defaultInformedConsentTextFormat;
    }

    @ResourceKey(value="session.finishedMessage.show")
    @TooltipResourceKey(value="session.finishedMessage.show.tooltip")
    @Column(name="show_session_complete_message", columnDefinition="BOOLEAN NOT NULL DEFAULT TRUE", nullable=false)
    public boolean isShowSessionCompleteMessage() {
        return this.showSessionCompleteMessage;
    }

    public void setShowSessionCompleteMessage(boolean showSessionCompleteMessage) {
        this.showSessionCompleteMessage = showSessionCompleteMessage;
    }

    @ResourceKey(value="recording.device.wake.lock")
    @TooltipResourceKey(value="recording.device.wake.lock.tooltip")
    public Boolean getRecordingDeviceWakeLock() {
        return this.recordingDeviceWakeLock;
    }

    public void setRecordingDeviceWakeLock(Boolean wakeLock) {
        this.recordingDeviceWakeLock = wakeLock;
    }

    @ResourceKey(value="recording.chunked")
    @TooltipResourceKey(value="recording.chunked.tooltip")
    public Boolean getChunkedRecording() {
        return this.chunkedRecording;
    }

    public void setChunkedRecording(Boolean chunkedRecording) {
        this.chunkedRecording = chunkedRecording;
    }

    @ResourceKey(value="consent.informed.paperform")
    public boolean isInformedConsentPaperForm() {
        return this.informedConsentPaperForm;
    }

    public void setInformedConsentPaperForm(boolean informedConsentPaperForm) {
        this.informedConsentPaperForm = informedConsentPaperForm;
    }

    @ManyToOne
    @ResourceKey(value="speaker.form.configuration")
    public FormConfiguration getSpeakerFormConfiguration() {
        return this.speakerFormConfiguration;
    }

    public void setSpeakerFormConfiguration(FormConfiguration speakerFormConfiguration) {
        this.speakerFormConfiguration = speakerFormConfiguration;
    }

    @Column(name="allow_pub_pseudonymized_export")
    @ResourceKey(value="project.allowPublicPseudonymizedAudioExport")
    public boolean isAllowPublicPseudonymizedAudioExport() {
        return this.allowPublicPseudonymizedAudioExport;
    }

    public void setAllowPublicPseudonymizedAudioExport(boolean allowPublicPseudonymizedAudioExport) {
        this.allowPublicPseudonymizedAudioExport = allowPublicPseudonymizedAudioExport;
    }

    @ResourceKey(value="last_visit_of_project_admin")
    @Temporal(value=TemporalType.TIMESTAMP)
    @XmlTransient
    public Date getLastVisitOfProjectAdmin() {
        return this.lastVisitOfProjectAdmin;
    }

    public void setLastVisitOfProjectAdmin(Date lastLoginOfProjectAdmin) {
        this.lastVisitOfProjectAdmin = lastLoginOfProjectAdmin;
    }

    public Project() {
        this(null);
    }

    public Project(String name) {
        this.name = name;
        this.getAllowedSpeechRecorderClients().add(SpeechRecorderClient.HTML5_ANGULAR);
    }

    @Id
    @Column(name="name", unique=true, nullable=false, length=100)
    @ResourceKey(value="name")
    @Input(required=true)
    @XmlID
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="uuid", length=36, unique=true, nullable=true, updatable=false)
    @ResourceKey(value="uuid")
    @TooltipResourceKey(value="uuid.tooltip")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Column(name="description", length=1000)
    @ResourceKey(value="description")
    @TextAreaView
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="registered")
    public Date getRegistered() {
        return this.registered;
    }

    public void setRegistered(Date registered) {
        this.registered = registered;
    }

    @ManyToOne
    @JoinColumn(name="registered_by_account")
    @ResourceKey(value="registered_by_account")
    @XmlTransient
    public Account getRegisteredByAccount() {
        return this.registeredByAccount;
    }

    public void setRegisteredByAccount(Account registeredByAccount) {
        this.registeredByAccount = registeredByAccount;
    }

    @Column(name="script_selection_mode", length=32)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="script.selection.mode")
    @TooltipResourceKey(value="script.selection.mode.tooltip")
    public ScriptSelectionMode getScriptSelectionMode() {
        return this.scriptSelectionMode;
    }

    public void setScriptSelectionMode(ScriptSelectionMode scriptSelectionMode) {
        this.scriptSelectionMode = scriptSelectionMode;
    }

    @Column(name="export_format_version")
    @ResourceKey(value="export.format.version")
    public Integer getExportFormatVersion() {
        return this.exportFormatVersion;
    }

    public void setExportFormatVersion(Integer exportFormatVersion) {
        this.exportFormatVersion = exportFormatVersion;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="project")
    @ResourceKey(value="sessions")
    @TooltipResourceKey(value="project.sessions.tooltip")
    @XmlTransient
    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="project", cascade={CascadeType.REMOVE})
    @ResourceKey(value="consents.informed")
    @XmlTransient
    public Set<InformedConsent> getInformedConsents() {
        return this.informedConsents;
    }

    public void setInformedConsents(Set<InformedConsent> informedConsents) {
        this.informedConsents = informedConsents;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="project_audio_device", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="audio_device_id", referencedColumnName="audio_device_id")})
    @ResourceKey(value="audio.devices")
    @OrderColumn
    public List<AudioDevice> getAudioDevices() {
        return this.audioDevices;
    }

    private List<AudioDevice> filterAudioDeviceList(Collection<AudioDevice> adColl, boolean hasJExt, boolean isRegex) {
        ArrayList<AudioDevice> filteredList = new ArrayList<AudioDevice>();
        for (AudioDevice ad : adColl) {
            String jExt = ad.getJextension();
            boolean devHasJExt = jExt != null && !jExt.equals("");
            boolean devIsRegex = ad.isRegex();
            if (devHasJExt != hasJExt || devIsRegex != isRegex) continue;
            filteredList.add(ad);
        }
        return filteredList;
    }

    public void setAudioDevices(List<AudioDevice> audioDevices) {
        this.audioDevices = audioDevices;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="project_dialect_region", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="dialect_region")})
    @ResourceKey(value="dialect_regions")
    @XmlTransient
    public Set<DialectRegion> getDialectRegions() {
        return this.dialectRegions;
    }

    public void setDialectRegions(Set<DialectRegion> dialectRegions) {
        this.dialectRegions = dialectRegions;
    }

    public String toString() {
        return this.name;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="project_organisations", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="organisation")})
    @DOMCollectionElement(collectionElementName="organisation")
    @ResourceKey(value="organisations")
    @XmlTransient
    public Set<Organisation> getOrganisations() {
        return this.organisations;
    }

    public void setOrganisations(Set<Organisation> organisations) {
        this.organisations = organisations;
    }

    @ManyToMany(cascade={CascadeType.REMOVE})
    @XmlTransient
    @ResourceKey(value="invitation.requests")
    public Set<InvitationRequest> getInvitationRequests() {
        return this.invitationRequests;
    }

    public void setInvitationRequests(Set<InvitationRequest> invitationRequests) {
        this.invitationRequests = invitationRequests;
    }

    @ElementCollection(targetClass=SpeechRecorderClient.class)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="project_spr_client")
    @Column(name="spr_client", length=100)
    @ResourceKey(value="speechrecorder.allowedClients")
    @XmlTransient
    public List<SpeechRecorderClient> getAllowedSpeechRecorderClients() {
        return this.allowedSpeechRecorderClients;
    }

    public void setAllowedSpeechRecorderClients(List<SpeechRecorderClient> allowedSpeechRecorderClients) {
        this.allowedSpeechRecorderClients = allowedSpeechRecorderClients;
    }

    @Column(name="context_path", length=20)
    @ResourceKey(value="context.path")
    @XmlTransient
    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @ManyToOne
    @JoinColumn(name="audioformat")
    @ResourceKey(value="audio.format")
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="project_scripts", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="script")})
    @ResourceKey(value="scripts.active")
    @TooltipResourceKey(value="scripts.active.tooltip")
    @XmlTransient
    public Set<Script> getScripts() {
        return this.scripts;
    }

    public void setScripts(Set<Script> scripts) {
        this.scripts = scripts;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="owningProject", cascade={CascadeType.REMOVE})
    @ResourceKey(value="scripts.owned")
    @TooltipResourceKey(value="scripts.owned.tooltip")
    @XmlTransient
    public Set<Script> getOwnedScripts() {
        return this.ownedScripts;
    }

    public void setOwnedScripts(Set<Script> ownedScripts) {
        this.ownedScripts = ownedScripts;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="owningProject", cascade={CascadeType.REMOVE})
    @ResourceKey(value="forms.owned")
    @XmlTransient
    public Set<FormConfiguration> getOwnedForms() {
        return this.ownedForms;
    }

    public void setOwnedForms(Set<FormConfiguration> ownedForms) {
        this.ownedForms = ownedForms;
    }

    @ManyToMany
    @JoinTable(name="project_account", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="account")})
    @ResourceKey(value="accounts")
    @XmlTransient
    public Set<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(Set<Account> accounts) {
        this.accounts = accounts;
    }

    @ManyToMany
    @JoinTable(name="project_admin_account", joinColumns={@JoinColumn(name="project")}, inverseJoinColumns={@JoinColumn(name="admin_account")})
    @ResourceKey(value="accounts.admin")
    @XmlTransient
    public Set<Account> getAdminAccounts() {
        return this.adminAccounts;
    }

    public void setAdminAccounts(Set<Account> adminAccounts) {
        this.adminAccounts = adminAccounts;
    }

    @Column(name="session_code", length=100)
    @ResourceKey(value="session.code")
    @XmlTransient
    public String getSessionCode() {
        return this.sessionCode;
    }

    public void setSessionCode(String sessionCode) {
        this.sessionCode = sessionCode;
    }

    @Column(name="default_research_purpose", length=10000)
    @ResourceKey(value="research.purpose.default.text")
    @TooltipResourceKey(value="research.purpose.default.text.tooltip")
    @TextAreaView
    public String getDefaultResearchPurpose() {
        return this.defaultResearchPurpose;
    }

    public void setDefaultResearchPurpose(String defaultResearchPurpose) {
        this.defaultResearchPurpose = defaultResearchPurpose;
    }

    @Column(name="default_research_purpose_lang_iso3", length=3)
    @ResourceKey(value="research.purpose.default.language")
    public String getDefaultResearchPurposeLanguageISO3code() {
        return this.defaultResearchPurposeLanguageISO3code;
    }

    public void setDefaultResearchPurposeLanguageISO3code(String defaultResearchPurposeLanguageISO3code) {
        this.defaultResearchPurposeLanguageISO3code = defaultResearchPurposeLanguageISO3code;
    }

    @OneToMany(mappedBy="project", cascade={CascadeType.REMOVE})
    @ResourceKey(value="research.purpose.default.text.additional_languages")
    @TooltipResourceKey(value="research.purpose.default.text.additional_languages.tooltip")
    public List<LocalizedDefaultPurposeText> getDefaultResearchPurposeAdditionalLanguages() {
        return this.defaultResearchPurposeAdditionalLanguages;
    }

    public void setDefaultResearchPurposeAdditionalLanguages(List<LocalizedDefaultPurposeText> defaultResearchPurposeAdditionalLanguages) {
        this.defaultResearchPurposeAdditionalLanguages = defaultResearchPurposeAdditionalLanguages;
    }

    @Column(name="default_informed_consent_text", length=100000)
    @ResourceKey(value="consent.informed.text.default")
    @TooltipResourceKey(value="consent.informed.text.tooltip")
    @TextAreaView
    public String getDefaultInformedConsentText() {
        return this.defaultInformedConsentText;
    }

    public void setDefaultInformedConsentText(String defaultInformedConsent) {
        this.defaultInformedConsentText = defaultInformedConsent;
    }

    @Column(name="default_informed_consent_text_lang_iso3", length=3)
    @ResourceKey(value="consent.informed.text.default.language")
    public String getDefaultInformedConsentTextLanguageISO3code() {
        return this.defaultInformedConsentTextLanguageISO3code;
    }

    public void setDefaultInformedConsentTextLanguageISO3code(String defaultInformedConsentLanguageISO3code) {
        this.defaultInformedConsentTextLanguageISO3code = defaultInformedConsentLanguageISO3code;
    }

    @OneToMany(mappedBy="project", cascade={CascadeType.REMOVE})
    @ResourceKey(value="informed.consent.localized.text.additional_languages")
    public List<LocalizedInformedConsentText> getInformedConsentTextAdditionalLanguages() {
        return this.informedConsentTextAdditionalLanguages;
    }

    public void setInformedConsentTextAdditionalLanguages(List<LocalizedInformedConsentText> localizedInformedConsentTexts) {
        this.informedConsentTextAdditionalLanguages = localizedInformedConsentTexts;
    }

    @Column(name="enable_broad_consent")
    @ResourceKey(value="consent.informed.broad.enable")
    public boolean getEnableBroadConsent() {
        return this.enableBroadConsent;
    }

    public void setEnableBroadConsent(boolean enableBroadConsent) {
        this.enableBroadConsent = enableBroadConsent;
    }

    @Column(name="show_stop_record_button")
    @ResourceKey(value="prompter.showStopRecordButton")
    public boolean isSpeakerWindowShowStopRecordAction() {
        return this.speakerWindowShowStopRecordAction;
    }

    public void setSpeakerWindowShowStopRecordAction(boolean speakerWindowShowStopRecordAction) {
        this.speakerWindowShowStopRecordAction = speakerWindowShowStopRecordAction;
    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="PLAIN_TEXT_UTF8", key="text.plain.utf8"), @MemberResourceKey(name="HTML5_SUBSET", key="text.html.5.subset")})
    public static enum TextFormat {
        PLAIN_TEXT_UTF8("plain_text_utf8"),
        HTML5_SUBSET("html5_subset");

        private final String value;

        private TextFormat(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static TextFormat getByValue(String value) {
            for (TextFormat tf : TextFormat.values()) {
                if (!tf.value.equals(value)) continue;
                return tf;
            }
            return null;
        }
    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="MEM_ENTIRE", key="storage.type.mem_entire"), @MemberResourceKey(name="MEM_CHUNKED", key="storage.type.mem_chunked"), @MemberResourceKey(name="DB_CHUNKED", key="storage.type.db_chunked"), @MemberResourceKey(name="NET_CHUNKED", key="storage.type.network_chunked"), @MemberResourceKey(name="MEM_ENTIRE_AUTO_NET_CHUNKED", key="storage.type.mem_entire_auto_network_chunked"), @MemberResourceKey(name="MEM_CHUNKED_AUTO_NET_CHUNKED", key="storage.type.mem_chunked_auto_network_chunked")})
    public static enum AudioStorageType {
        MEM_ENTIRE("Memory entire"),
        MEM_CHUNKED("Memory chunked"),
        DB_CHUNKED("Database chunked"),
        NET_CHUNKED("Network chunked"),
        MEM_ENTIRE_AUTO_NET_CHUNKED("Memory entire auto network chunked"),
        MEM_CHUNKED_AUTO_NET_CHUNKED("Memory chunked auto network chunked");

        private final String value;

        private AudioStorageType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static AudioStorageType getByValue(String value) {
            for (AudioStorageType scrSel : AudioStorageType.values()) {
                if (!scrSel.value.equals(value)) continue;
                return scrSel;
            }
            return null;
        }
    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="LEAST_USAGE", key="script.selection.mode.least_usage"), @MemberResourceKey(name="MANUAL", key="script.selection.mode.manual")})
    public static enum ScriptSelectionMode {
        LEAST_USAGE("least_usage"),
        MANUAL("manual");

        private final String value;

        private ScriptSelectionMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static ScriptSelectionMode getByValue(String value) {
            for (ScriptSelectionMode scrSel : ScriptSelectionMode.values()) {
                if (!scrSel.value.equals(value)) continue;
                return scrSel;
            }
            return null;
        }
    }
}

