package ipsk.db.speech.project;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Project;
import ipsk.db.speech.Project.TextFormat;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;

@Entity
@Table(name = "project_localized_informed_consent", schema = "public")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
//@ResourceKey("localized_message")
//@PluralResourceKey("localized_messages")
@PreferredDisplayOrder("id,project,textFormat,languageISO3code,localizedText")
@XmlType(name="localized_informed_consent_text")
public class LocalizedInformedConsentText {

	private int id;
	private String languageISO3code;
	private String localizedText;
	
	private Project project;
	
	
	public LocalizedInformedConsentText(){
		super();
	}
	@Id
	@Column(name = "id", unique = true, nullable = false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
    public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	@ManyToOne
	@ResourceKey("project")
	@XmlTransient
	public Project getProject() {
		return project;
	}
	public void setProject(Project project) {
		this.project = project;
	}
	
	private TextFormat textFormat=null;
	
	@Column(name = "text_format", length = 32)
	@Enumerated(EnumType.STRING)
	@ResourceKey("text.format")
	public TextFormat getTextFormat() {
		return textFormat;
	}

	public void setTextFormat(TextFormat textFormat) {
		this.textFormat = textFormat;
	}

	
	@Column(length = 3, updatable = false)
	@ResourceKey("language")
	@Input(required=true)
	public String getLanguageISO3code() {
		return languageISO3code;
	}

	public void setLanguageISO3code(String languageISO3code) {
		this.languageISO3code = languageISO3code;
	}
	@Column(length = 10000)
	@TextAreaView
	@ResourceKey("text")
	public String getLocalizedText() {
		return localizedText;
	}

	public void setLocalizedText(String localizedText) {
		this.localizedText = localizedText;
	}
	
}
