/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import java.io.Serializable;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class UserRoleId
implements Serializable {
    public String login;
    public RoleName roleName;

    public UserRoleId() {
    }

    public UserRoleId(String login, RoleName roleName) {
        this.login = login;
        this.roleName = roleName;
    }

    public UserRoleId(String parseString) {
        int lastCommaIdx = parseString.lastIndexOf(",");
        this.login = parseString.substring(0, lastCommaIdx).trim();
        String roleNameStr = parseString.substring(lastCommaIdx + 1).trim();
        this.roleName = RoleName.parse(roleNameStr);
    }

    @Column(name="login", length=100)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="role_name", length=100)
    @Enumerated(value=EnumType.STRING)
    public RoleName getRoleName() {
        return this.roleName;
    }

    public void setRoleName(RoleName roleName) {
        this.roleName = roleName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof UserRoleId)) {
            return false;
        }
        UserRoleId castOther = (UserRoleId)other;
        return (this.getLogin() == castOther.getLogin() || this.getLogin() != null && castOther.getLogin() != null && this.getLogin().equals(castOther.getLogin())) && (this.getRoleName() == castOther.getRoleName() || this.getRoleName() != null && castOther.getRoleName() != null && this.getRoleName().equals((Object)castOther.getRoleName()));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getLogin() == null ? 0 : this.getLogin().hashCode());
        result = 37 * result + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        return result;
    }

    public String toString() {
        return this.login + ", " + this.roleName;
    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="ADMIN", key="administrator"), @MemberResourceKey(name="PROJECT_ADMIN", key="project.administrator"), @MemberResourceKey(name="PROJECT_ANNOTATOR", key="project.annotator"), @MemberResourceKey(name="ORGANISAION", key="organisation"), @MemberResourceKey(name="SUBJECT", key="userRole.subject")})
    public static enum RoleName {
        ADMIN("administrator"),
        PROJECT_ADMIN("project.administrator"),
        ANNOTATON_PROJECT_ADMIN(null),
        PROJECT_MEMBER(null),
        SUBJECT("userRole.subject"),
        ORGANISATION("organisation"),
        PROJECT_ANNOTATOR("project.annotator");

        private String resourceKey = null;

        public String getResourceKey() {
            return this.resourceKey;
        }

        private RoleName(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public String getName() {
            return this.name();
        }

        public static RoleName parse(String roleName) {
            return RoleName.valueOf(roleName.trim().toUpperCase(Locale.ENGLISH));
        }
    }
}

