/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.project;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.validation.Input;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Entity
@Table(name="project_localized_informed_consent", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="id,project,textFormat,languageISO3code,localizedText")
@XmlType(name="localized_informed_consent_text")
public class LocalizedInformedConsentText {
    private int id;
    private String languageISO3code;
    private String localizedText;
    private Project project;
    private Project.TextFormat textFormat = null;

    @Id
    @Column(name="id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @ManyToOne
    @ResourceKey(value="project")
    @XmlTransient
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Column(name="text_format", length=32)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="text.format")
    public Project.TextFormat getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(Project.TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    @Column(length=3, updatable=false)
    @ResourceKey(value="language")
    @Input(required=true)
    public String getLanguageISO3code() {
        return this.languageISO3code;
    }

    public void setLanguageISO3code(String languageISO3code) {
        this.languageISO3code = languageISO3code;
    }

    @Column(length=10000)
    @TextAreaView
    @ResourceKey(value="text")
    public String getLocalizedText() {
        return this.localizedText;
    }

    public void setLocalizedText(String localizedText) {
        this.localizedText = localizedText;
    }
}

