package ipsk.db.speech.account;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@Entity
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder("id,uuid,login,email,requestDate,validUntil,userRoles,projects,organisation")
@ResourceKey("invitation.request")
public class InvitationRequest extends AccountRequest {

	private List<Project> projects=new ArrayList<>();
	
	@ManyToMany(mappedBy = "invitationRequests")
	@ResourceKey("projects")
	public List<Project> getProjects() {
		return projects;
	}
	public void setProjects(List<Project> projects) {
		this.projects = projects;
	}
	
	@ElementCollection
	@ResourceKey("user_roles")
	public Set<String> getUserRoles() {
		return userRoles;
	}
	
	public void setUserRoles(Set<String> userRoles) {
		this.userRoles = userRoles;
	}

	private Set<String> userRoles=new HashSet<>();
	
	private Organisation organisation=null;
	
	@ManyToOne
	@ResourceKey("organisation")
	public Organisation getOrganisation() {
		return organisation;
	}
	public void setOrganisation(Organisation organisation) {
		this.organisation = organisation;
	}
	
	public InvitationRequest() {
		super();
	}
	
	public InvitationRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil,
			List<Project> projects) {
		super(uuid,login,email,requestDate,validUntil);
		this.projects=projects;
	}
	public InvitationRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil, Organisation orga) {
		super(uuid,login,email,requestDate,validUntil);
		this.organisation=orga;
	}
	public String toString() {
		String s="Account invitation request for username "+getLogin()+", E-Mail: "+getEmail();
		Organisation orga=getOrganisation();
		if(orga!=null) {
			s=s+", Organisation: "+orga;
		}
	
		return s;
	}

}
