/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.account;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.account.AccountRequest;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;

@Entity
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@PreferredDisplayOrder(value="id,uuid,login,email,requestDate,validUntil,userRoles,projects,organisation")
@ResourceKey(value="invitation.request")
public class InvitationRequest
extends AccountRequest {
    private List<Project> projects = new ArrayList<Project>();
    private Set<String> userRoles = new HashSet<String>();
    private Organisation organisation = null;

    @ManyToMany(mappedBy="invitationRequests")
    @ResourceKey(value="projects")
    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    @ElementCollection
    @ResourceKey(value="user_roles")
    public Set<String> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Set<String> userRoles) {
        this.userRoles = userRoles;
    }

    @ManyToOne
    @ResourceKey(value="organisation")
    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public InvitationRequest() {
    }

    public InvitationRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil, List<Project> projects) {
        super(uuid, login, email, requestDate, validUntil);
        this.projects = projects;
    }

    public InvitationRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil, Organisation orga) {
        super(uuid, login, email, requestDate, validUntil);
        this.organisation = orga;
    }

    public String toString() {
        String s = "Account invitation request for username " + this.getLogin() + ", E-Mail: " + this.getEmail();
        Organisation orga = this.getOrganisation();
        if (orga != null) {
            s = s + ", Organisation: " + orga;
        }
        return s;
    }
}

