/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.project;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="media_storage_format", schema="public")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="media.storage.format")
@PreferredDisplayOrder(value="audioEncoding,audioPCMSampleSizeInBits")
public class MediaStorageFormat {
    private String name;
    private Project project;
    private AudioEncoding audioEncoding = AudioEncoding.PCM_SIGNED;
    private Integer audioPCMSampleSizeInBits = null;

    @Id
    @Column(nullable=false)
    @ResourceKey(value="name")
    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MapsId
    @OneToOne
    @JoinColumn(name="name")
    @XmlTransient
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @ResourceKey(value="audio.format.encoding")
    @Enumerated(value=EnumType.STRING)
    public AudioEncoding getAudioEncoding() {
        return this.audioEncoding;
    }

    public void setAudioEncoding(AudioEncoding encoding) {
        this.audioEncoding = encoding;
    }

    @ResourceKey(value="quantisation")
    public Integer getAudioPCMSampleSizeInBits() {
        return this.audioPCMSampleSizeInBits;
    }

    public void setAudioPCMSampleSizeInBits(Integer sampleSizeInBits) {
        this.audioPCMSampleSizeInBits = sampleSizeInBits;
    }

    public String toString() {
        Object audioDescr = this.audioEncoding != null ? this.audioEncoding.toString() : "(Default encoding)";
        if (!AudioEncoding.PCM_FLOAT.equals((Object)this.audioEncoding) && this.audioPCMSampleSizeInBits != null) {
            audioDescr = (String)audioDescr + ", " + this.audioPCMSampleSizeInBits + " bits";
        }
        return "Audio: " + (String)audioDescr;
    }

    public static enum AudioEncoding {
        PCM_SIGNED,
        PCM_FLOAT;

    }
}

