/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech;

import ipsk.beans.HiddenProperties;
import ipsk.beans.LinkID;
import ipsk.beans.PreferredDisplayOrder;
import ipsk.beans.dom.DOMAttributes;
import ipsk.beans.dom.DOMCollectionElement;
import ipsk.beans.dom.DOMElements;
import ipsk.db.speech.Organisation;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.SessionDTO;
import ipsk.db.speech.Speaker;
import ipsk.db.speech.SpeechRecorderClient;
import ipsk.db.speech.XMLIntegerAdapter;
import ipsk.db.speech.adapter.EmptyStringAsNullAdapter;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import ipsk.util.annotations.TextAreaView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@Table(name="session")
@NamedQueries(value={@NamedQuery(name="session.bySpeaker", query="SELECT sess FROM Session sess WHERE ?1 MEMBER OF sess.speakers"), @NamedQuery(name="sessions.forProject", query="SELECT s FROM Session s WHERE s.project = ?1")})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@HiddenProperties(value={"httpSessionId"})
@PreferredDisplayOrder(value="sessionId,uuid,project,status,type,sealed,date,loadedDate,startedTrainingDate,startedDate,completedDate,lastRestartDate,sealedDate,exportForAnnotation,script,code,speakers,recordingFiles,comment")
@DOMAttributes(value={"sessionId"})
@DOMElements(value={"state", "date", "sealed", "loadedDate", "startedTrainingDate", "startedDate", "completedDate", "code", "speakers", "script", "comment"})
@XmlType(name="session", namespace="session", propOrder={"sessionId", "uuid", "status", "type", "project", "date", "loadedDate", "startedTrainingDate", "startedDate", "completedDate", "lastRestartDate", "sealedDate", "code", "speakers", "script", "environment", "sealed", "exportForAnnotation", "comment"})
public class Session
implements Serializable {
    private Integer sessionId;
    private String uuid;
    private Script script;
    private Project project;
    private Organisation organisation;
    private String code;
    private String environment;
    private String comment;
    private Date date;
    private Date loadedDate;
    private Date startedTrainingDate;
    private Date startedDate;
    private Date completedDate;
    private Date lastRestartDate;
    private Date sealedDate;
    private Type type;
    private Status status = Status.CREATED;
    private SpeechRecorderClient speechRecorderClient = null;
    private boolean sealed = false;
    private String httpSessionId;
    private String storageDirectoryURL;
    private boolean exportForAnnotation = false;
    private Set<RecordingFile> recordingFiles = new HashSet<RecordingFile>(0);
    private Boolean hasRecordings = null;
    private Set<Speaker> speakers = new HashSet<Speaker>(0);
    private List<Recording> cachedMissingRecordings;

    @Column(nullable=false)
    @ResourceKey(value="session.export_for_annotation")
    public boolean isExportForAnnotation() {
        return this.exportForAnnotation;
    }

    public void setExportForAnnotation(boolean exportForAnnotation) {
        this.exportForAnnotation = exportForAnnotation;
    }

    public Session() {
    }

    public Session(int sessionId) {
        this.sessionId = sessionId;
    }

    @Id
    @Column(name="session_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @LinkID
    @XmlID
    @XmlJavaTypeAdapter(value=XMLIntegerAdapter.class)
    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    @Column(name="uuid", length=36, unique=true, nullable=true, updatable=false)
    @ResourceKey(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="script_id")
    @ResourceKey(value="script")
    @XmlIDREF
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    @Column(name="code", length=100)
    @ResourceKey(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Enumerated(value=EnumType.STRING)
    @XmlTransient
    @ResourceKey(value="speechrecorder.client")
    public SpeechRecorderClient getSpeechRecorderClient() {
        return this.speechRecorderClient;
    }

    public void setSpeechRecorderClient(SpeechRecorderClient speechRecorderClient) {
        this.speechRecorderClient = speechRecorderClient;
    }

    @Column(name="environment", length=100)
    @ResourceKey(value="environment")
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Column(name="comment", length=1000)
    @XmlJavaTypeAdapter(value=EmptyStringAsNullAdapter.class)
    @ResourceKey(value="comments")
    @TextAreaView
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @ManyToOne
    @JoinColumn(name="project")
    @ResourceKey(value="project")
    @XmlIDREF
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Column(updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="point_in_time")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="loaded")
    public Date getLoadedDate() {
        return this.loadedDate;
    }

    public void setLoadedDate(Date loadedDate) {
        this.loadedDate = loadedDate;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="started_training")
    public Date getStartedTrainingDate() {
        return this.startedTrainingDate;
    }

    public void setStartedTrainingDate(Date startedTrainingDate) {
        this.startedTrainingDate = startedTrainingDate;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="started")
    public Date getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="completed")
    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="last_restart")
    public Date getLastRestartDate() {
        return this.lastRestartDate;
    }

    public void setLastRestartDate(Date lastRestartDate) {
        this.lastRestartDate = lastRestartDate;
    }

    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    @ResourceKey(value="sealed.at")
    public Date getSealedDate() {
        return this.sealedDate;
    }

    public void setSealedDate(Date sealedDate) {
        this.sealedDate = sealedDate;
    }

    @OneToMany(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, mappedBy="session")
    @ResourceKey(value="recording_files")
    @XmlTransient
    public Set<RecordingFile> getRecordingFiles() {
        return this.recordingFiles;
    }

    public void setRecordingFiles(Set<RecordingFile> recordingFiles) {
        this.recordingFiles = recordingFiles;
    }

    @Transient
    public void markHasRecordings(Boolean hasRecordings) {
        this.hasRecordings = hasRecordings;
    }

    @Transient
    public boolean hasRecordings() {
        if (this.hasRecordings != null) {
            return this.hasRecordings;
        }
        if (this.recordingFiles != null) {
            return this.recordingFiles.size() > 0;
        }
        return false;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="participates", joinColumns={@JoinColumn(name="session_id")}, inverseJoinColumns={@JoinColumn(name="speaker_id")})
    @DOMCollectionElement(collectionElementName="speaker")
    @ResourceKey(value="participants")
    @XmlIDREF
    public Set<Speaker> getSpeakers() {
        return this.speakers;
    }

    public void setSpeakers(Set<Speaker> speakers) {
        this.speakers = speakers;
    }

    @Column(name="type", length=10)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="type")
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Column(name="status", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="status")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Column
    @ResourceKey(value="sealed")
    public boolean getSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    @Column(name="jsessionid", length=100)
    @XmlTransient
    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    private void setRandomUUID() {
        if (this.uuid == null) {
            UUID uuidO = UUID.randomUUID();
            this.uuid = uuidO.toString();
        }
    }

    protected void setCurrentDate() {
        if (this.date == null) {
            this.setDate(new Date());
        }
    }

    @PrePersist
    public void prePersist() {
        this.setRandomUUID();
        this.setCurrentDate();
    }

    @PreUpdate
    public void setSealedDate() {
        if (this.sealedDate == null && this.sealed) {
            this.sealedDate = new Date();
        }
    }

    public String toString() {
        return "Session: " + this.sessionId;
    }

    @Column(name="storage_dir_url", length=1000)
    @ResourceKey(value="storage.dir")
    @XmlTransient
    public String getStorageDirectoryURL() {
        return this.storageDirectoryURL;
    }

    public void setStorageDirectoryURL(String storageDirectoryURL) {
        this.storageDirectoryURL = storageDirectoryURL;
    }

    @ManyToOne
    @JoinColumn(name="organisation_id")
    @ResourceKey(value="organisation")
    @XmlTransient
    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    @Transient
    public Double getMaxLevel() {
        Double maxLevel = null;
        Set<RecordingFile> recordingFiles = this.getRecordingFiles();
        if (recordingFiles != null) {
            for (RecordingFile rf : recordingFiles) {
                Double rfML;
                Group g;
                Section section;
                Recording r = rf.getRecording();
                if (r != null && (section = (g = r.getGroup()).getSection()) != null && section.isTraining() || (rfML = rf.getMaxLevel()) == null) continue;
                if (maxLevel != null) {
                    if (!(rfML > maxLevel)) continue;
                    maxLevel = rfML;
                    continue;
                }
                maxLevel = rfML;
            }
        }
        return maxLevel;
    }

    @Transient
    public List<Recording> getMissingRecordingItems() {
        ArrayList<Recording> missingRecordingItems = new ArrayList<Recording>();
        HashSet<Recording> recordedItems = new HashSet<Recording>();
        Set<RecordingFile> rfs = this.getRecordingFiles();
        for (RecordingFile rf : rfs) {
            Recording rr = rf.getRecording();
            recordedItems.add(rr);
        }
        Script script = this.getScript();
        if (script == null) {
            return null;
        }
        List<Section> sections = script.getSections();
        for (Section s : sections) {
            if (s.isTraining()) continue;
            List<Group> gs = s.getGroups();
            for (Group g : gs) {
                List<PromptItem> gPis = g.getPromptItems();
                for (PromptItem pi : gPis) {
                    Recording r;
                    if (!(pi instanceof Recording) || recordedItems.contains(r = (Recording)pi)) continue;
                    missingRecordingItems.add(r);
                }
            }
        }
        return missingRecordingItems;
    }

    @Transient
    public Long getSessionDuration() {
        Long dur = null;
        if (this.startedDate != null && this.completedDate != null) {
            dur = this.completedDate.getTime() - this.startedDate.getTime();
        }
        return dur;
    }

    public void applyDTO(SessionDTO dto) {
        this.applyDTO(dto, true);
    }

    public void applyDTO(SessionDTO dto, boolean forceNullProperties) {
        Integer dtoSessId = dto.getSessionId();
        Integer sessId = this.getSessionId();
        if (dtoSessId != null && sessId != null && !sessId.equals(dtoSessId)) {
            throw new IllegalArgumentException("DTO object to apply has different ID: " + sessId + ", DTO ID: " + dtoSessId);
        }
        Status st = dto.getStatus();
        if (this.status == null) {
            this.setStatus(st);
        } else if (forceNullProperties || st != null && st.compareTo(this.status) >= 0) {
            this.setStatus(st);
        }
        Date ld = dto.getLoadedDate();
        if (forceNullProperties || ld != null) {
            this.setLoadedDate(ld);
        }
        Date std = dto.getStartedTrainingDate();
        if (forceNullProperties || std != null) {
            this.setStartedTrainingDate(std);
        }
        Date sd = dto.getStartedDate();
        if (forceNullProperties || sd != null) {
            this.setStartedDate(sd);
        }
        Date rsd = dto.getRestartedDate();
        if (forceNullProperties || rsd != null) {
            this.setLastRestartDate(rsd);
        }
        Date cd = dto.getCompletedDate();
        if (forceNullProperties || cd != null) {
            this.setCompletedDate(cd);
        }
    }

    public static enum LogLevel {
        SEVERE,
        WARNING,
        INFO,
        CONFIG,
        FINE,
        FINER,
        FINEST;

    }

    @XmlType(name="sessionType")
    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="TEST", key="test"), @MemberResourceKey(name="TEST_DEF_A", key="test.any_audio_device"), @MemberResourceKey(name="SINE_TEST", key="test.sinus"), @MemberResourceKey(name="NORM", key="normal")})
    public static enum Type {
        TEST,
        TEST_DEF_A,
        SINE_TEST,
        NORM;

    }

    @EnumResourceKeys(memberResourceKeys={@MemberResourceKey(name="CREATED", key="created"), @MemberResourceKey(name="LOADED", key="loaded"), @MemberResourceKey(name="STARTED_TRAINING", key="started_training"), @MemberResourceKey(name="STARTED", key="started"), @MemberResourceKey(name="COMPLETED", key="completed")})
    public static enum Status {
        CREATED,
        LOADED,
        STARTED_TRAINING,
        STARTED,
        COMPLETED;

    }
}

