/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.speaker;

import ipsk.beans.PropertyValidationResult;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Speaker;
import ipsk.util.LocalizableMessage;

public class SpeakerValidator {
    public static void validateSpeakerCode(ValidationResult vr, String spkCode) {
        if (spkCode != null && !spkCode.isEmpty()) {
            PropertyValidationResult namePropVr;
            LocalizableMessage msg;
            if (!spkCode.matches("^[\\w-:! \\.]*$")) {
                vr.setType(ValidationResult.Type.ERRORS);
                msg = new LocalizableMessage("Illegal character(s) in speaker code. Allowed are alphanumeric ASCII characters and - and _");
                namePropVr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg);
                vr.putPropertyValidationResult("code", namePropVr);
            }
            if (spkCode.matches(".*\\.{2,}?.*")) {
                vr.setType(ValidationResult.Type.ERRORS);
                msg = new LocalizableMessage("Speaker code must not contain dot sequences");
                namePropVr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg);
                vr.putPropertyValidationResult("code", namePropVr);
            }
            if (spkCode.matches("^\\s+.*")) {
                vr.setType(ValidationResult.Type.ERRORS);
                msg = new LocalizableMessage("Speaker code must not start with blank characters");
                namePropVr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg);
                vr.putPropertyValidationResult("code", namePropVr);
            }
            if (spkCode.matches(".*\\s+$")) {
                vr.setType(ValidationResult.Type.ERRORS);
                msg = new LocalizableMessage("Speaker code must not end with blank characters");
                namePropVr = new PropertyValidationResult(PropertyValidationResult.Type.ERROR, msg);
                vr.putPropertyValidationResult("code", namePropVr);
            }
        }
    }

    public static ValidationResult validateSpeaker(Speaker speaker) {
        ValidationResult vr = new ValidationResult();
        SpeakerValidator.validateSpeakerCode(vr, speaker.getCode());
        return vr;
    }
}

