package ipsk.db.speech.script;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@Entity
@Table(name = "recscript_virtualviewbox")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("virtualviewbox")
@PluralResourceKey("virtualviewbox")
public class VirtualViewBox {

	protected static final String ELEMENT_NAME = "virtualviewbox";
	protected static final String ATTR_NAME_HEIGHT = "height";

	private int id;
	
    @Id
    @Column(name="id", unique = true, nullable = false)
    @ResourceKey("id")
    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
       this.id=id;
    }
    
    private Recordingscript recordingscript;
	
    @MapsId
	@OneToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "id")
	@XmlTransient
	public Recordingscript getRecordingscript() {
		return recordingscript;
	}

	public void setRecordingscript(Recordingscript recordingScript) {
		this.recordingscript = recordingScript;
	}
	
	
	private int height;

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public VirtualViewBox() {
		super();
	}

	public VirtualViewBox(Element e) throws ScriptSyntaxException {
		super();
		if (e != null) {
			String attrHeight = e.getAttribute(ATTR_NAME_HEIGHT);
			if (attrHeight != null) {
				try {
				 height = Integer.parseInt(attrHeight);
				}catch(NumberFormatException nfe) {
					throw new ScriptSyntaxException("Value "+attrHeight+" for attribute "+ATTR_NAME_HEIGHT+" of element "+e.getNodeName()+" is not a number!");
				}
			}
		}
	}

	public Element toElement(Document d) {
		Element e = d.createElement(ELEMENT_NAME);
		e.setAttribute(ATTR_NAME_HEIGHT, Integer.toString(height));
		return e;
	}

}
