/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.script.Nonrecording;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.persistence.ImmutibilityProvider;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="recgroup")
@XmlType(name="group", namespace="group", propOrder={"order", "promptItems"})
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="group")
@PluralResourceKey(value="groups")
@PreferredDisplayOrder(value="groupId,section,order,*")
public class Group
extends BasicPropertyChangeSupport
implements Serializable,
PropertyChangeListener,
ImmutibilityProvider {
    public static final String ELEMENT_NAME = "group";
    private int groupId;
    private Order order;
    protected Section section;
    private List<PromptItem> shuffledPromptItems = null;
    private List<PromptItem> promptItems = new ArrayList<PromptItem>();
    private String[] comments = new String[0];

    @Id
    @Column(name="group_id", unique=true, nullable=false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    @XmlTransient
    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public Group() {
    }

    public Group(Group group) {
        this.promptItems.addAll(group.promptItems);
    }

    public Group(Element e) {
        this(null, e, null);
    }

    public Group(IntegerSequenceGenerator seqGen, Element e, Section section) {
        this();
        Attr attr;
        if (seqGen != null) {
            this.setGroupId(seqGen.getAndIncrement());
        }
        if ((attr = e.getAttributeNode("order")) != null) {
            this.setOrder(Order.getByValue(attr.getValue()));
        }
        NodeList childs = e.getChildNodes();
        ArrayList<String> commentsArrList = new ArrayList<String>();
        int ci = 0;
        while (ci < childs.getLength()) {
            Node n = childs.item(ci);
            if (n.getNodeType() == 8) {
                commentsArrList.add(n.getNodeValue());
            }
            ++ci;
        }
        this.comments = commentsArrList.toArray(new String[0]);
        ArrayList<PromptItem> promptItemArrList = new ArrayList<PromptItem>();
        NodeList eNodeList = e.getChildNodes();
        boolean promptItemPosition = false;
        int i = 0;
        while (i < eNodeList.getLength()) {
            Node n = eNodeList.item(i);
            if (n.getNodeType() == 1) {
                Element piE = (Element)n;
                if (piE.getTagName().equals("recording")) {
                    Recording recording = new Recording(seqGen, piE);
                    recording.setGroup(this);
                    promptItemArrList.add(recording);
                } else if (piE.getTagName().equals("nonrecording")) {
                    Nonrecording nonrecording = new Nonrecording(seqGen, piE);
                    nonrecording.setGroup(this);
                    promptItemArrList.add(nonrecording);
                }
            }
            ++i;
        }
        this.setPromptItems(promptItemArrList);
        this.setSection(section);
    }

    public Group(IntegerSequenceGenerator seqGen, PromptItem pi, Section section) {
        this();
        ArrayList<PromptItem> pis = new ArrayList<PromptItem>(1);
        pi.setGroup(this);
        pis.add(pi);
        this.setPromptItems(pis);
        this.setSection(section);
    }

    public Object clone() throws CloneNotSupportedException {
        Group cg = new Group();
        cg.setOrder(this.getOrder());
        cg.propertyChangeSupport = new PropertyChangeSupport(this);
        List<PromptItem> pis = this.promptItems;
        ArrayList<PromptItem> cPis = new ArrayList<PromptItem>();
        for (PromptItem pi : pis) {
            PromptItem cPi = (PromptItem)pi.clone();
            cPis.add(cPi);
        }
        cg.promptItems = cPis;
        return cg;
    }

    @Column(name="ordering", length=100)
    @Enumerated(value=EnumType.STRING)
    @ResourceKey(value="order")
    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        Order oldOrder = this.order;
        this.order = order;
        this.propertyChangeSupport.firePropertyChange("order", (Object)oldOrder, (Object)this.order);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="section_id")
    @ResourceKey(value="section")
    @XmlTransient
    public Section getSection() {
        return this.section;
    }

    public void setSection(Section section) {
        Section oldSection = this.section;
        this.section = section;
        this.propertyChangeSupport.firePropertyChange("section", oldSection, this.section);
    }

    @Transient
    @XmlTransient
    public Order getNNOrder() {
        if (this.order == null) {
            return Order.SEQUENTIAL;
        }
        return this.order;
    }

    @Transient
    public void shuffleItems() {
        ArrayList<PromptItem> shuffledPis = new ArrayList<PromptItem>(this.promptItems);
        Random rnd = new Random();
        int i = this.promptItems.size();
        while (i > 1) {
            this.swap(shuffledPis, i - 1, rnd.nextInt(i));
            --i;
        }
        this.shuffledPromptItems = shuffledPis;
    }

    private void swap(List<PromptItem> items, int i, int j) {
        PromptItem tmp = items.get(i);
        items.set(i, items.get(j));
        items.set(j, tmp);
    }

    @Transient
    public List<PromptItem> shuffledPromptItems() {
        if (this.getNNOrder().equals((Object)Order.RANDOM)) {
            if (this.shuffledPromptItems == null) {
                this.shuffleItems();
            }
            return this.shuffledPromptItems;
        }
        return this.promptItems;
    }

    @Transient
    public void updateUpwardsRelations() {
        for (PromptItem pi : this.promptItems) {
            pi.setGroup(this);
        }
    }

    @OneToMany(cascade={CascadeType.REMOVE, CascadeType.MERGE}, fetch=FetchType.LAZY, mappedBy="group")
    @OrderColumn(name="position")
    @ResourceKey(value="promptitems")
    public List<PromptItem> getPromptItems() {
        return this.promptItems;
    }

    public void setPromptItems(List<PromptItem> promptItems) {
        this.promptItems = promptItems;
        this.shuffledPromptItems = null;
    }

    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        Order order = this.getOrder();
        if (order != null) {
            e.setAttribute("order", order.value());
        }
        String[] stringArray = this.comments;
        int n = this.comments.length;
        int n2 = 0;
        while (n2 < n) {
            String comm = stringArray[n2];
            e.appendChild(d.createComment(comm));
            ++n2;
        }
        List<PromptItem> pis = this.getPromptItems();
        for (PromptItem pi : pis) {
            e.appendChild(pi.toElement(d));
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        String hPropName = "group." + propName;
        this.propertyChangeSupport.firePropertyChange(hPropName, evt.getOldValue(), evt.getNewValue());
    }

    @Transient
    @XmlTransient
    public List<String> getMIMETypes() {
        ArrayList<String> piMms = new ArrayList<String>();
        for (PromptItem pi : this.promptItems) {
            piMms.addAll(pi.getMIMETypes());
        }
        return piMms;
    }

    public String toString() {
        return "Group " + this.getGroupId();
    }

    void apply() {
        for (PromptItem pi : this.getPromptItems()) {
            pi.apply();
        }
        if (this.getNNOrder().equals((Object)Order.RANDOM)) {
            if (this.shuffledPromptItems == null) {
                this.shuffleItems();
            }
            this.setPromptItems(this.shuffledPromptItems);
            this.setOrder(Order.RANDOMIZED);
        }
    }

    @Transient
    public void defaultPrerecdelay(int defaultPrerecdelay) {
        List<PromptItem> pis = this.getPromptItems();
        for (PromptItem pi : pis) {
            if (!(pi instanceof Recording)) continue;
            Recording r = (Recording)pi;
            r.setDefaultPrerecdelay(defaultPrerecdelay);
        }
    }

    @Transient
    public void defaultPostrecdelay(int defaultPostrecdelay) {
        List<PromptItem> pis = this.getPromptItems();
        for (PromptItem pi : pis) {
            if (!(pi instanceof Recording)) continue;
            Recording r = (Recording)pi;
            r.setDefaultPostrecdelay(defaultPostrecdelay);
        }
    }

    @Transient
    public void defaultAutoplay(boolean defaultAutoplay) {
        List<PromptItem> pis = this.getPromptItems();
        for (PromptItem pi : pis) {
            pi.defaultAutoplay(defaultAutoplay);
        }
    }

    @Transient
    public void defaultVirtualViewBox(VirtualViewBox defaultVirtualViewBox) {
        for (PromptItem pi : this.promptItems) {
            pi.defaultVirtualViewBox(defaultVirtualViewBox);
        }
    }

    @Transient
    public boolean isImmutable() {
        Section s = this.getSection();
        return s != null && s.isImmutable();
    }

    @Transient
    public boolean isRemovable() {
        return !this.isImmutable();
    }

    @XmlType(namespace="group")
    public static enum Order {
        SEQUENTIAL("sequential"),
        RANDOM("random"),
        RANDOMIZED("randomized");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static Order getByValue(String value) {
            Order[] orderArray = Order.values();
            int n = orderArray.length;
            int n2 = 0;
            while (n2 < n) {
                Order pp = orderArray[n2];
                if (pp.value.equals(value)) {
                    return pp;
                }
                ++n2;
            }
            return null;
        }
    }
}

