/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script.prompt.doc;

import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.P;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.util.PluralResourceKey;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Entity
@Table(name="fmt_prompt_body_element")
@ResourceBundleName(value="ipsk.db.speech.PropertyNames")
@ResourceKey(value="body")
@PluralResourceKey(value="body")
public class Body
implements Serializable,
Cloneable {
    public static final String ELEMENT_NAME = "body";
    private int id;
    private PromptDoc promptDoc;
    private List<Block> blocks = new ArrayList<Block>();

    @Id
    @Column(name="id", unique=true, nullable=false)
    @ResourceKey(value="id")
    @XmlTransient
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @OneToOne
    @MapsId
    @JoinColumn(name="id")
    @XmlTransient
    public PromptDoc getPromptDoc() {
        return this.promptDoc;
    }

    public void setPromptDoc(PromptDoc promptDoc) {
        this.promptDoc = promptDoc;
    }

    public Body() {
        this(null);
    }

    public Body(Element e) {
        if (e != null) {
            NodeList childs = e.getChildNodes();
            int ci = 0;
            while (ci < childs.getLength()) {
                Element ce;
                String cen;
                Node n = childs.item(ci);
                if (n.getNodeType() == 1 && "p".equals(cen = (ce = (Element)n).getTagName())) {
                    P p = new P(ce);
                    this.blocks.add(p);
                }
                ++ci;
            }
        }
    }

    @OneToMany(mappedBy="body", cascade={CascadeType.ALL})
    @OrderColumn(name="block_position")
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    @Transient
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        if (this.blocks != null) {
            for (Block blk : this.blocks) {
                Element blkE = blk.toElement(d);
                e.appendChild(blkE);
            }
        }
        return e;
    }

    @Transient
    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Body p = (Body)c;
        return p;
    }

    @Transient
    public String toPlainTextString() {
        String pt = "";
        for (Block block : this.blocks) {
            pt = pt.concat(block.toPlainTextString());
        }
        return pt;
    }

    @Transient
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<body>");
        for (Block block : this.blocks) {
            sb.append(block.toString());
        }
        sb.append("</body>");
        return sb.toString();
    }
}

