/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script;

import ipsk.db.speech.BasicPropertyChangeSupport;
import ipsk.db.speech.script.Property;
import ipsk.db.speech.script.Script;
import ipsk.util.ResourceKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Entity
@Table(name="metadata", schema="public")
public class Metadata
extends BasicPropertyChangeSupport
implements Serializable {
    private static final String ELEMENT_NAME = "metadata";
    private int metadataId;
    private Script script;
    private List<Property> properties = new ArrayList<Property>();
    private ArrayList<ArrayList<String>> comments = new ArrayList();

    public Metadata() {
    }

    public Metadata(int metadataId) {
        this();
        this.metadataId = metadataId;
    }

    public Metadata(Element e) {
        this();
        NodeList nl = e.getChildNodes();
        this.properties.clear();
        String tmpKey = null;
        String tmpValue = null;
        int ePos = 0;
        int ci = 0;
        while (ci < nl.getLength()) {
            Node n = nl.item(ci);
            if (n.getNodeType() == 8) {
                String comm = n.getNodeValue();
                ArrayList<String> pComms = null;
                while (this.comments.size() <= ePos) {
                    this.comments.add(new ArrayList());
                }
                pComms = this.comments.get(ePos);
                pComms.add(comm);
            } else if (n.getNodeType() == 1) {
                Element el = (Element)n;
                if (el.getNodeName().equals("key")) {
                    tmpKey = el.getTextContent();
                } else if (el.getNodeName().equals("value")) {
                    tmpValue = el.getTextContent();
                    Property p = new Property();
                    p.setKey(tmpKey);
                    p.setValue(tmpValue);
                    this.properties.add(p);
                }
                ++ePos;
            }
            ++ci;
        }
    }

    @Id
    @Column(name="metadata_id", unique=true)
    @GeneratedValue(generator="id_gen")
    @ResourceKey(value="id")
    public int getMetadataId() {
        return this.metadataId;
    }

    public void setMetadataId(int metadataId) {
        int oldMetadataId = this.metadataId;
        this.metadataId = metadataId;
        this.propertyChangeSupport.firePropertyChange("metadataId", oldMetadataId, this.metadataId);
    }

    @OneToOne
    @JoinColumn(name="script_id")
    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        Script oldScript = this.script;
        this.script = script;
        this.propertyChangeSupport.firePropertyChange("script", oldScript, this.script);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="metadata")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    private void appendComments(Document d, Element e, int ePos) {
        ArrayList<String> posCmts;
        if (ePos < this.comments.size() && (posCmts = this.comments.get(ePos)) != null) {
            for (String c : posCmts) {
                e.appendChild(d.createComment(c));
            }
        }
    }

    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        int ePos = 0;
        for (Property p : this.properties) {
            this.appendComments(d, e, ePos);
            Element keyE = d.createElement("key");
            String keyStr = p.getKey();
            if (keyStr == null) {
                keyStr = "";
            }
            Text keyText = d.createTextNode(keyStr);
            keyE.appendChild(keyText);
            e.appendChild(keyE);
            this.appendComments(d, e, ++ePos);
            Element valueE = d.createElement("value");
            String valStr = p.getValue();
            if (valStr == null) {
                valStr = "";
            }
            Text valText = d.createTextNode(valStr);
            valueE.appendChild(valText);
            e.appendChild(valueE);
            this.appendComments(d, e, ++ePos);
        }
        ++ePos;
        while (ePos < this.comments.size()) {
            this.appendComments(d, e, ePos);
            ++ePos;
        }
        return e;
    }
}

