/*
 * Decompiled with CFR 0.152.
 */
package ipsk.db.speech.script.prompt.doc;

import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.db.speech.script.prompt.doc.TextFormatElement;
import java.beans.Transient;
import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Entity
@Table(name="fmt_prompt_textformat_element")
@DiscriminatorValue(value="font")
@XmlType(namespace="mediaitem", propOrder={"size", "style", "weight", "text"})
public class Font
extends TextFormatElement {
    protected static final String ELEMENT_NAME = "font";
    protected static final String ATT_SIZE = "size";
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private String size = null;
    public static String NORMAL = "normal";
    protected static final String ATT_STYLE = "style";
    public static String ITALIC = "italic";
    private String style = null;
    protected static final String ATT_WEIGHT = "weight";
    public static String BOLD = "bold";
    private String weight = null;
    public Text text = null;

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public Font() {
    }

    public Font(Element n) {
        Attr attr = n.getAttributeNode(ATT_SIZE);
        if (attr != null) {
            this.setSize(attr.getValue());
        }
        if ((attr = n.getAttributeNode(ATT_STYLE)) != null) {
            this.setStyle(attr.getValue());
        }
        if ((attr = n.getAttributeNode(ATT_WEIGHT)) != null) {
            this.setWeight(attr.getValue());
        }
        NodeList textElNl = n.getElementsByTagName("text");
        int i = 0;
        while (i < textElNl.getLength()) {
            Element textEl = (Element)textElNl.item(i);
            this.text = new Text(textEl);
            ++i;
        }
    }

    @Override
    public Element toElement(Document d) {
        Element e = d.createElement(ELEMENT_NAME);
        if (this.size != null) {
            e.setAttribute(ATT_SIZE, this.getSize());
        }
        if (this.style != null) {
            e.setAttribute(ATT_STYLE, this.getStyle());
        }
        if (this.weight != null) {
            e.setAttribute(ATT_WEIGHT, this.getWeight());
        }
        if (this.text != null) {
            e.appendChild(this.text.toElement(d));
        }
        return e;
    }

    public Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        Font b = (Font)c;
        return b;
    }

    @Override
    public String toPlainTextString() {
        return this.getText().getText();
    }

    @javax.persistence.Transient
    @Transient
    public FontSize fontSize() {
        if (this.size == null) {
            return new FontSize();
        }
        String trSizeStr = this.size.trim();
        if (trSizeStr.endsWith("em")) {
            String relSizeStr = trSizeStr.replaceFirst("\\s*em", "");
            return new FontSize(new BigDecimal(relSizeStr), true);
        }
        if (trSizeStr.endsWith("%")) {
            String relPercSizeStr = trSizeStr.replaceFirst("\\s*%", "");
            BigDecimal relPercSize = new BigDecimal(relPercSizeStr);
            return new FontSize(relPercSize.divide(new BigDecimal(100)), true);
        }
        if (trSizeStr.endsWith("px")) {
            String absSizeStr = trSizeStr.replaceFirst("\\s*px", "");
            BigDecimal absSize = new BigDecimal(absSizeStr);
            return new FontSize(absSize);
        }
        BigDecimal absSize = new BigDecimal(trSizeStr);
        return new FontSize(absSize);
    }

    @javax.persistence.Transient
    @Transient
    public double toRealFontSize(double parentSize) {
        return this.toRealFontSize(parentSize, null);
    }

    @javax.persistence.Transient
    @Transient
    public double toRealFontSize(double parentSize, Double scaleFactor) {
        FontSize fs = this.fontSize();
        if (fs != null) {
            double fsVal = fs.getValue().doubleValue();
            if (fs.isRelative()) {
                return fsVal * parentSize;
            }
            if (scaleFactor == null) {
                return fsVal;
            }
            return fsVal * scaleFactor;
        }
        return parentSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<font");
        if (this.size != null) {
            sb.append(" size=\"");
            sb.append(this.size);
            sb.append("\"");
        }
        if (this.style != null) {
            sb.append(" style=\"");
            sb.append(this.style);
            sb.append("\"");
        }
        if (this.weight != null) {
            sb.append(" weight=\"");
            sb.append(this.weight);
            sb.append("\"");
        }
        sb.append(">");
        sb.append(this.getText());
        sb.append("</font>");
        return sb.toString();
    }

    public static class FontSize {
        private BigDecimal value = null;
        private boolean relative = false;

        public boolean isRelative() {
            return this.relative;
        }

        public FontSize() {
            this(null, true);
        }

        public FontSize(BigDecimal absSize) {
            this(absSize, false);
        }

        public FontSize(BigDecimal value, boolean relative) {
            this.value = value;
            this.relative = relative;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public boolean isDefault() {
            return this.value == null;
        }

        public String toString() {
            if (this.value == null) {
                return "default (100%)";
            }
            if (this.relative) {
                return String.valueOf(this.value.multiply(HUNDRED).toString()) + "%";
            }
            return this.value.toString();
        }
    }
}

